/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.dataload;

import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class LoadedDataMapping {
    private List<DataGen> dataGens = new ArrayList<DataGen>();

    public DataGen getMapped(String serviceId, String resourceId, String genId) {
        for (DataGen dg : this.dataGens) {
            if (!dg.serviceId.equals(serviceId) || !dg.resourceId.equals(resourceId) || !dg.genId.equals(genId)) continue;
            return dg;
        }
        return null;
    }

    public void setMapping(String serviceId, String resourceId, String genId, String tableLike) {
        DataGen alreadyMapped = this.getMapped(serviceId, resourceId, genId);
        if (alreadyMapped != null) {
            throw ErrorContext.iaef((String)"Already mapped: %s-%s-%s", (Object)serviceId, (Object[])new Object[]{resourceId, genId});
        }
        DataGen dg = new DataGen();
        dg.serviceId = serviceId;
        dg.resourceId = resourceId;
        dg.genId = genId;
        dg.tableLike = tableLike;
        this.dataGens.add(dg);
    }

    public void unmap(String serviceId, String resourceId, String genId) {
        DataGen dg = this.getMapped(serviceId, resourceId, genId);
        if (dg == null) {
            throw ErrorContext.iaef((String)"Not mapped: %s-%s-%s", (Object)serviceId, (Object[])new Object[]{resourceId, genId});
        }
        this.dataGens.remove(dg);
    }

    public List<DataGen> getAllForServiceGen(String serviceId, String genId) {
        ArrayList<DataGen> ret = new ArrayList<DataGen>();
        for (DataGen dg : this.dataGens) {
            if (!dg.serviceId.equals(serviceId) || !dg.genId.equals(genId)) continue;
            ret.add(dg);
        }
        return ret;
    }

    public static class DataGen {
        public String serviceId;
        public String resourceId;
        public String genId;
        public String connectionName;
        public String tableLike;
    }
}

