/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;

public class ToNumber
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1 && args[0] != null) {
            if (args[0] instanceof Number) {
                return args[0];
            }
            String s = args[0].toString().trim();
            if (s.length() > 0) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Double.parseDouble(s);
                    }
                    catch (NumberFormatException e) {
                        return new EvalError("Cannot parse to number");
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ToNumber.DOCUMENTATION", "Returns <code>o</code> converted to a number.").withParams("o").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("\"5\"").returns("5"));
    }
}

