/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.dataiku.dip.io.ColumnBlock;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.WrappedCell;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Val
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        Object fieldValue;
        WrappedCell wc;
        CellTuple tuple;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one argument");
        }
        String columnName = args[0].toString().trim();
        if (args.length == 3) {
            int offset = Val.extractOffset(args[2]);
            if (offset > 0) {
                Object fieldValue2;
                int index;
                List previousRows = (List)bindings.get("previousRows");
                if (!(previousRows == null || (index = previousRows.size() - offset) < 0 || (fieldValue2 = ((Map)previousRows.get(index)).get(columnName)) == null || fieldValue2 instanceof String && ((String)fieldValue2).isEmpty())) {
                    return ExpressionUtils.parseValue(fieldValue2);
                }
                return args[1];
            }
            if (offset < 0) {
                throw new IllegalArgumentException("The offset argument must be a greater than or equal to zero");
            }
        }
        if (!((tuple = (CellTuple)bindings.get("cells")) == null || (wc = (WrappedCell)tuple.getField(columnName, bindings)) == null || (fieldValue = wc.getField("value", bindings)) == null || fieldValue instanceof String && ((String)fieldValue).isEmpty())) {
            return ExpressionUtils.parseValue(fieldValue);
        }
        ColumnBlock columnBlock = UdafUtils.getColumnBlock(bindings, columnName);
        if (columnBlock != null) {
            String defaultValue = columnBlock.getMemoryType() == ColumnBlock.MemoryType.DOUBLE ? null : "";
            return UdafUtils.getColumnValue(bindings, columnBlock, args.length == 2 ? args[1] : defaultValue);
        }
        if (bindings.containsKey("UDAF_BINDING_KEY")) {
            throw new RuntimeException("Columns must be used inside aggregations.");
        }
        return args.length >= 2 ? args[1] : null;
    }

    @Override
    public boolean treatFirstArgumentAsColumnName() {
        return true;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Val.DOCUMENTATION", "Returns the value of a column. Specify an optional <code>defaultValue</code> to replace empty cells with it. Specify an optional <code>offset</code> to retrieve the value of the column on a previous row.<br/>The type of the resulting column is auto-detected (use <code>strval</code> or <code>numval</code> to force either a string or a number).").withParams("string columnName", "[string defaultValue]", "[number offset]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.VALUE_ACCESS", "Value access functions");
    }

    @Override
    public boolean requirePreviousRows() {
        return true;
    }

    @Override
    public Map<String, Integer> getNumberOfPreviousRowsRequiredByColumns(Object[] args) {
        if (args != null && args.length == 3) {
            String columnName = args[0] != null ? args[0].toString().trim() : "";
            return Map.of(columnName, Val.extractOffset(args[2]));
        }
        return Collections.emptyMap();
    }

    static int extractOffset(Object o) {
        if (o instanceof Number) {
            int offset = ((Number)o).intValue();
            if (offset < 0) {
                throw new IllegalArgumentException("The offset argument must a be greater than or equal to zero");
            }
            return offset;
        }
        if (o != null) {
            throw new IllegalArgumentException("The offset argument must be a valid number");
        }
        return Integer.MAX_VALUE;
    }
}

