/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class EncodeToBase64
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length >= 1 && args[0] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            String charset = "utf-8";
            if (args.length >= 2 && args[1] != null) {
                Object charsetO = args[1];
                charset = charsetO instanceof String ? (String)charsetO : charsetO.toString();
            }
            try {
                byte[] bytes = s.getBytes(charset);
                return Base64.encodeBase64String((byte[])bytes);
            }
            catch (UnsupportedEncodingException e) {
                return new EvalError("The string '" + s + "' cannot be encoded in " + charset);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.EncodeToBase64.DOCUMENTATION", "Returns the Base64 representation of a string. By default, the string is written using the UTF-8 charset.").withParams("string s, [string charset]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"H\"").returns("\"SA==\""));
    }
}

