/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SplitByCharType
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        Object o;
        if (args.length == 1 && (o = args[0]) != null) {
            String s = o instanceof String ? (String)o : o.toString();
            return StringUtils.splitByCharacterType((String)s);
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 strings");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.SplitByCharType.DOCUMENTATION", "Returns an array of strings obtained by splitting <code>s</code> grouping consecutive chars by their unicode type.").withParams("string s").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"Hello_world 101!?!\"").returns("[\"H\",\"ello\",\"_\",\"world\",\" \",\"101\",\"!?!\"]"));
    }
}

