/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.server.DkuStandardServletMultipartResolver;
import com.dataiku.dip.server.SlowAndFailInterceptor;
import com.dataiku.dip.server.controllers.RequestParamJsonConverter;
import com.dataiku.dip.server.controllers.RequestResponseBodyJsonConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class DkuBackendInitializer {

    @NotInRootContext
    @Configuration
    @EnableAspectJAutoProxy
    public static class DispatcherServletConfiguration
    extends WebMvcConfigurationSupport {
        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.add((HttpMessageConverter<?>)new RequestResponseBodyJsonConverter());
            this.addDefaultHttpMessageConverters(converters);
            converters.removeIf(converter -> converter instanceof MappingJackson2XmlHttpMessageConverter);
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new SlowAndFailInterceptor());
        }

        public FormattingConversionService mvcConversionService() {
            DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(false);
            conversionService.addConverter((GenericConverter)new RequestParamJsonConverter());
            return conversionService;
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
        }

        @Bean
        public MultipartResolver multipartResolver() {
            return new DkuStandardServletMultipartResolver();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NotInRootContext {
    }

    @Configuration
    public static class RootContextConfiguration {
    }
}

