/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.pam;

import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.security.pam.PAMService;
import com.dataiku.dip.security.pam.PAMSettings;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jvnet.libpam.PAMException;
import org.springframework.beans.factory.annotation.Autowired;

public class PamCredentialsAuthenticator
implements UserCredentialsAuthenticator,
UserSupplier {
    private final PAMService pamService;
    protected PAMSettings pamSettings;

    @Autowired
    public PamCredentialsAuthenticator(PAMService pamService) {
        this.pamService = pamService;
    }

    @Override
    public boolean canSyncOnDemand() {
        return false;
    }

    @Override
    public boolean canFetchUsers() {
        return false;
    }

    @Override
    public boolean canFetchGroups() {
        return false;
    }

    @Override
    public String getDefaultProfile() {
        return this.pamSettings.defaultUserProfile;
    }

    @Override
    public UserCredentialsAuthenticatorSettings getAuthenticatorSettings() {
        return this.pamSettings;
    }

    @Override
    public UserSupplierSettings getUserSupplierSettings() {
        return this.pamSettings;
    }

    @Override
    public UserIdentity authenticate(String login, String password) throws ServerAuthenticationFailure, UserAuthenticationException {
        try {
            login = this.pamService.authenticate(this.pamSettings.serviceName, login, password);
        }
        catch (PAMException e) {
            throw new UserAuthenticationException("PAM authentication failed", e);
        }
        return new UserIdentity(UserSourceType.PAM, login);
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws ServerAuthenticationFailure {
        if (userIdentity.sourceType != UserSourceType.PAM) {
            throw new ServerAuthenticationFailure("Unable to read a user of a different source type than PAM: " + String.valueOf((Object)userIdentity.sourceType));
        }
        UserAttributes userAttributes = new UserAttributes();
        if (StringUtils.isNotEmpty((String)this.pamSettings.defaultGroup)) {
            userAttributes.dkuGroupNames.add(this.pamSettings.defaultGroup);
        }
        return userAttributes;
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        throw new ServerAuthenticationFailure("PAM cannot fetch users");
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        throw new ServerAuthenticationFailure("PAM cannot fetch groups");
    }
}

