from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..joint_normal.fitted_joint_normal import FittedJointNormal, _FittedJointNormal
    from ..kde2d.fitted_kde2d import FittedKDE2D, _FittedKDE2D
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.distributions.Distribution2D$FittedDistribution2D
Via: com.dataiku.dip.eda.compute.computations.bivariate.Fit2DDistribution$Fit2DDistributionResult
'''


class _FittedDistribution2D(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.distributions.Distribution2D$FittedDistribution2D
FittedDistribution2D = Union[
    'FittedJointNormal',
    'FittedKDE2D',
]

# Types of class com.dataiku.dip.eda.compute.distributions.Distribution2D$FittedDistribution2D in PolyJSON mappings (as literal type)
FittedDistribution2DTypeLiteral = Literal["joint_normal", "kde_2d", ]


# EOF
