from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from ....online.llm_client.single_completion_query import SingleCompletionQuery, _SingleCompletionQuery
from ..python_server_command.python_server_command import PythonServerCommand, _PythonServerCommand

'''
Translated from class com.dataiku.dip.llm.io.commands.ProcessSinglePromptCommand
Via: PyModel annotation in the class hierarchy
'''


class _ProcessSinglePromptCommand(_PythonServerCommand, TypedDict):
    type: Literal["process-completion-query"]
    prompt: str
    query: 'SingleCompletionQuery'
    settings: 'CompletionSettings'
    stream: bool


ProcessSinglePromptCommand = _ProcessSinglePromptCommand


# EOF
