(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    app.controller('TreemapChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils) {

        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };

        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data);
        };

        $scope.getYDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.yHierarchyDimension : $scope.chart.def.yDimension;
    });
})();
