/* global describe, beforeEach, module, inject, it, expect */

describe("SemanticVersionService", function() {
    beforeEach(() => {
        module('dataiku.services', function () {
        });
    });

    describe("compareVersions", function () {
        it("works on numeric only versions", function () {
            inject(function (SemanticVersionService) {
                expect(SemanticVersionService.compareVersions("0.0.0", "0.0.0")).toBe(0);
                expect(SemanticVersionService.compareVersions("0.0.1", "0.1.0")).toBe(-1);
                expect(SemanticVersionService.compareVersions("1.0", "0.1.0")).toBe(1);
                expect(SemanticVersionService.compareVersions("0.0.10", "0.0.9")).toBe(1);
                expect(SemanticVersionService.compareVersions("0.10.0", "0.9.9")).toBe(1);
            });
        });

        it("works with alphanumeric versions", function () {
            inject(function (SemanticVersionService) {
                // numeric comparison first
                expect(SemanticVersionService.compareVersions("0.1.2alpha1", "0.1.1beta8")).toBe(1);
                // same version number, comparing remaining string lexicographically
                expect(SemanticVersionService.compareVersions("0.1.2alpha1", "0.1.2beta8")).toBe(-1);
                expect(SemanticVersionService.compareVersions("0.1.2alpha1", "0.1.2alpha3")).toBe(-1);
                // Only one starting with number, favored
                expect(SemanticVersionService.compareVersions("0.1.2alpha1", "0.1.weirdVersion")).toBe(1);
                expect(SemanticVersionService.compareVersions("0.1.weirdVersion", "0.1.2alpha1")).toBe(-1);
                // Not starting with number, lexicographical comparison
                expect(SemanticVersionService.compareVersions("myFirstVersion", "mySecondVersion")).toBe(-1);
                expect(SemanticVersionService.compareVersions("mySecondVersion", "myFirstVersion")).toBe(1);
                expect(SemanticVersionService.compareVersions("myFirstVersion", "myFirstVersion")).toBe(0);
                // Released version greater than pre-release
                expect(SemanticVersionService.compareVersions("1.1.0-beta2", "1.1.0")).toBe(-1);
                expect(SemanticVersionService.compareVersions("1.1.0-beta2", "1.1.0-beta2")).toBe(0);
                expect(SemanticVersionService.compareVersions("1.1.0", "1.1.0-beta2")).toBe(1);
            });
        });
    });
});