from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .manual_tool_call import ManualToolCall, _ManualToolCall
    from .output_mode import OutputMode
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$ManualToolCallBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _ManualToolCallBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["MANUAL_TOOL_CALL"]
    nextBlock: str
    outputMode: 'OutputMode'
    outputScratchpadKey: str
    outputStateKey: str
    tool: 'ManualToolCall'


ManualToolCallBlock = _ManualToolCallBlock


# EOF
