from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..bivariate.covariance.covariance import Covariance, _Covariance
    from ..bivariate.fit_2d_distribution.fit_2d_distribution import Fit2DDistribution, _Fit2DDistribution
    from ..bivariate.fit_curve.fit_curve import FitCurve, _FitCurve
    from ..bivariate.kendall_tau.kendall_tau import KendallTau, _KendallTau
    from ..bivariate.mutual_information.mutual_information import MutualInformation, _MutualInformation
    from ..bivariate.pearson.pearson import Pearson, _Pearson
    from ..bivariate.spearman.spearman import Spearman, _Spearman
from .computation import Computation, _Computation

'''
Translated from class com.dataiku.dip.eda.compute.computations.Computation$BivariateComputation
Via: PyModel annotation in the class hierarchy
'''


class _BivariateComputation(_Computation, TypedDict):
    xColumn: str
    yColumn: str


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.Computation$BivariateComputation
BivariateComputation = Union[
    'Covariance',
    'Fit2DDistribution',
    'FitCurve',
    'KendallTau',
    'MutualInformation',
    'Pearson',
    'Spearman',
]

# Types of class com.dataiku.dip.eda.compute.computations.Computation$BivariateComputation in PolyJSON mappings (as literal type)
BivariateComputationTypeLiteral = Literal["covariance", "fit_2d_distribution", "fit_curve", "kendall_tau", "mutual_information", "pearson", "spearman", ]


# EOF
