from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .trend import Trend
from ...available_result.available_result import AvailableResult, _AvailableResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.MannKendallTest$MannKendallTestResult
Via: PyModel annotation in the class hierarchy
'''


class _MannKendallTestResult(_AvailableResult, TypedDict):
    type: Literal["mann_kendall"]
    intercept: NotRequired[Optional[float]]
    pValue: float
    score: float
    slope: NotRequired[Optional[float]]
    statistic: float
    tau: float
    trend: 'Trend'
    variance: float


MannKendallTestResult = _MannKendallTestResult


# EOF
