import logging

from .. import NextBlock, BlockHandler

logger = logging.getLogger("dku.agents.blocks_graph")

class SetScratchpadEntriesBlockHandler(BlockHandler):
    def __init__(self, turn, sequence_context, block_config):
        super().__init__(turn, sequence_context, block_config)

    def process_stream(self, trace):
        logger.info("Set scratchpad entries block starting with config %s" % self.block_config)

        for entry in self.block_config.get("entriesToSet", []):
            key = entry.get("key")
            value = entry.get("value")
            logger.info("Setting scratchpad key %s to value %s" % (key, value))

            cel_engine = self.standard_cel_engine()
            self.sequence_context.scratchpad[key] = cel_engine.evaluate(value)

        yield NextBlock(id=self.block_config.get("nextBlock"))
