from dataiku.runnables import Runnable
import os
import datetime
import time
import json
import logging

from cleaning import  delete_and_report

class MyRunnable(Runnable):
    def __init__(self, project_key, config, plugin_config):
        self.project_key = project_key
        self.config = config

    def get_progress_target(self):
        return (100, 'NONE')

    def run(self, progress_callback):
        self.dip_home = os.environ['DIP_HOME']
        self.perform_deletion = self.config.get("performDeletion", False)
        self.maximum_age = int(self.config.get("age", 15))
        self.maximum_timestamp = int(time.mktime((datetime.datetime.now() - datetime.timedelta(days=self.maximum_age)).timetuple()))
        
        if self.config.get('allProjects', False):
            self.project_keys = []
            self.project_keys = self.project_keys + [project_key for project_key in os.listdir(os.path.join(self.dip_home, 'webappruns'))]
            self.project_keys = self.project_keys + [project_key for project_key in os.listdir(os.path.join(self.dip_home, 'code_studios/exec'))]
            self.project_keys = list(set(self.project_keys)) # unicize
        else:
            self.project_keys = [self.project_key]
            
        do_webapps = self.config.get('webApps', True)
        do_codestudios = self.config.get('codeStudios', True)
        
        logging.info("Check for runs in %s" % json.dumps(self.project_keys))

        self.to_delete = []
        for project_key in self.project_keys:
            if do_webapps:
                webappruns_folder = os.path.join(self.dip_home, 'webappruns', project_key)
                try:
                    for webapp_id in os.listdir(webappruns_folder):
                        webapp_folder = os.path.join(self.dip_home, 'webappruns', project_key, webapp_id)   
                        try:
                            for run_id in os.listdir(webapp_folder):
                                if not os.path.isdir(os.path.join(webapp_folder, run_id)):
                                    continue # ignore the json files, if any
                                try:
                                    if os.stat(os.path.join(webapp_folder, run_id)).st_mtime < self.maximum_timestamp:
                                        self.to_delete.append(["webappruns", project_key, webapp_id, run_id])
                                except:
                                    # Can fail if a dir entry is removed while enumerating. No log to remove then.
                                    pass
                        except:
                            # Can fail if webapp is removed while running. No log to remove then.
                            pass
                except:
                    # Can fail if project is removed while running. No log to remove then.
                    pass
            if do_codestudios:
                codestudios_folder = os.path.join(self.dip_home, 'code_studios/exec', project_key)
                try:
                    for codestudio_id in os.listdir(codestudios_folder):
                        codestudio_folder = os.path.join(self.dip_home, 'code_studios/exec', project_key, codestudio_id)   
                        try:
                            for run_id in os.listdir(codestudio_folder):
                                if not os.path.isdir(os.path.join(codestudio_folder, run_id)):
                                    continue # ignore the json files, if any
                                try:
                                    if os.stat(os.path.join(codestudio_folder, run_id)).st_mtime < self.maximum_timestamp:
                                        self.to_delete.append(["code_studios/exec", project_key, codestudio_id, run_id])
                                except:
                                    # Can fail if a dir entry is removed while enumerating. No log to remove then.
                                    pass
                        except:
                            # Can fail if webapp is removed while running. No log to remove then.
                            pass
                except:
                    # Can fail if project is removed while running. No log to remove then.
                    pass
        def base_path_to_type(x):
            if x == 'webappruns':
                return 'Webapp'
            elif x == 'code_studios/exec':
                return 'Code studio'
            else:
                return x
        html = delete_and_report(self.to_delete, self.dip_home, progress_callback, self.perform_deletion, 'webapp/codestudio runs', ['Type', 'Project', 'Id', 'Run'], formats=[base_path_to_type])
        return html
