from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .type import Type

'''
Translated from class com.dataiku.dip.agents.tools.utils.JsonSchemaElement
Via: com.dataiku.dip.agents.tools.utils.JsonSchema
'''

__JsonSchemaElement = TypedDict('__JsonSchemaElement', {
    '$defs': Dict[str, '_JsonSchemaElement'],
    '$ref': str,
})


class _JsonSchemaElement(__JsonSchemaElement):
    description: str
    enum: List[str]
    items: '_JsonSchemaElement'
    minItems: int
    properties: Dict[str, '_JsonSchemaElement']
    required: List[str]
    type: 'Type'
    uniqueItems: bool


#    Translate from class com.dataiku.dip.agents.tools.utils.JsonSchemaElement
#    @deprecated Translation is incomplete: annotate it with PyModel to generate a union of all concrete subclasses
JsonSchemaElement = _JsonSchemaElement


# EOF
