from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....agents.tools.utils.json_schema.json_schema import JsonSchema, _JsonSchema
    from .abstract_tool_call import AbstractToolCall, _AbstractToolCall
    from .hierarchy_entry import HierarchyEntry, _HierarchyEntry

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$ToolValidationRequest
Via: com.dataiku.dip.llm.online.LLMClient$SimpleCompletionResponse
'''


class _ToolValidationRequest(TypedDict):
    allowEditingInputs: bool
    blockId: str
    hierarchy: List['HierarchyEntry']
    id: str
    message: str
    toolCall: 'AbstractToolCall'
    toolDescription: str
    toolInputSchema: 'JsonSchema'
    toolName: str
    toolRef: str
    toolType: str


ToolValidationRequest = _ToolValidationRequest


# EOF
