/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.JSONFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.utils.package$;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.InputStreamEntity;
import com.dataiku.dss.spark.DataikuSparkContext$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLEncoder;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StdDataikuSparkContext$ {
    public static StdDataikuSparkContext$ MODULE$;
    private boolean initializedHostPort;
    private AbstractCodeBasedActivityRunner.FlowSpec flowSpec;
    private String apiPath;
    private String apiHost;
    private String apiRemoteHost;
    private int apiPort;
    private String apiProtocol;
    private String apiURL;
    private String apiRemoteURL;
    private String apiServerCert;
    private String activityId;
    private final Logger com$dataiku$dip$spark$StdDataikuSparkContext$$logger;

    static {
        new StdDataikuSparkContext$();
    }

    public boolean initializedHostPort() {
        return this.initializedHostPort;
    }

    public void initializedHostPort_$eq(boolean x$1) {
        this.initializedHostPort = x$1;
    }

    public AbstractCodeBasedActivityRunner.FlowSpec flowSpec() {
        return this.flowSpec;
    }

    public void flowSpec_$eq(AbstractCodeBasedActivityRunner.FlowSpec x$1) {
        this.flowSpec = x$1;
    }

    public String apiPath() {
        return this.apiPath;
    }

    public void apiPath_$eq(String x$1) {
        this.apiPath = x$1;
    }

    public String apiHost() {
        return this.apiHost;
    }

    public void apiHost_$eq(String x$1) {
        this.apiHost = x$1;
    }

    public String apiRemoteHost() {
        return this.apiRemoteHost;
    }

    public void apiRemoteHost_$eq(String x$1) {
        this.apiRemoteHost = x$1;
    }

    public int apiPort() {
        return this.apiPort;
    }

    public void apiPort_$eq(int x$1) {
        this.apiPort = x$1;
    }

    public String apiProtocol() {
        return this.apiProtocol;
    }

    public void apiProtocol_$eq(String x$1) {
        this.apiProtocol = x$1;
    }

    public String apiURL() {
        return this.apiURL;
    }

    public void apiURL_$eq(String x$1) {
        this.apiURL = x$1;
    }

    public String apiRemoteURL() {
        return this.apiRemoteURL;
    }

    public void apiRemoteURL_$eq(String x$1) {
        this.apiRemoteURL = x$1;
    }

    public String apiServerCert() {
        return this.apiServerCert;
    }

    public void apiServerCert_$eq(String x$1) {
        this.apiServerCert = x$1;
    }

    public String activityId() {
        return this.activityId;
    }

    public void activityId_$eq(String x$1) {
        this.activityId = x$1;
    }

    public void uninitialize() {
        StdDataikuSparkContext$ stdDataikuSparkContext$ = this;
        synchronized (stdDataikuSparkContext$) {
            this.initializedHostPort_$eq(false);
        }
        DataikuSparkContext$.MODULE$.resetContext();
    }

    public synchronized void initialize() {
        if (!this.initializedHostPort()) {
            Some some;
            String string;
            Some some2;
            String string2;
            Option<String> serverKind;
            this.initializedHostPort_$eq(true);
            package$.MODULE$.initializeApplication(package$.MODULE$.initializeApplication$default$1(), package$.MODULE$.initializeApplication$default$2());
            String localHostname = InetAddress.getLocalHost().getHostName();
            Option<String> option = serverKind = com.dataiku.dip.remoterun.package$.MODULE$.get("DKU_SERVER_KIND");
            if (option instanceof Some && "JEK".equals(string2 = (String)(some2 = (Some)option).value()) ? true : option instanceof Some && "CAK".equals(string = (String)(some = (Some)option).value())) {
                this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Running for job");
                this.apiHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_HOST", localHostname));
                this.apiRemoteHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_HOST", com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_HOST_FOR_REMOTE", localHostname)));
                this.apiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_PORT", "0"))).toInt());
                this.apiProtocol_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_PROTOCOL", "http"));
                this.flowSpec_$eq((AbstractCodeBasedActivityRunner.FlowSpec)com.dataiku.dip.remoterun.package$.MODULE$.getFlowSpec().getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
                this.apiPath_$eq(this.flowSpec().tintercomAPIBase);
                this.activityId_$eq(this.flowSpec().currentActivityId);
                this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(45).append("Init: running in flow, ").append(serverKind.get()).append(" port = ").append(this.apiPort()).append(" activityId = ").append(this.activityId()).toString());
            } else {
                this.apiPath_$eq("dip/api/tintercom");
                this.apiHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_HOST", localHostname));
                this.apiRemoteHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_HOST", com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_HOST_FOR_REMOTE", localHostname)));
                this.apiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_PORT", "0"))).toInt());
                this.apiProtocol_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_PROTOCOL", "http"));
                this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(53).append("Init: not running in flow (type is ").append(com.dataiku.dip.remoterun.package$.MODULE$.get("DKU_SERVER_KIND")).append("), backend port = ").append(this.apiPort()).toString());
            }
            this.apiServerCert_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_SERVER_CERT", null));
            if (com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_API_TICKET", null) != null) {
                PluginSettingsResolver.setupRemoteResolution((this.flowSpec() != null ? 1 : 0) != 0, (String)new StringBuilder(4).append(this.apiProtocol()).append("://").append(this.apiHost()).append(":").append(this.apiPort()).toString(), (String)this.apiServerCert(), (String)com.dataiku.dip.remoterun.package$.MODULE$.getTicketFromEnv());
            }
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(25).append("Init: api host = ").append(this.apiHost()).append(" port = ").append(this.apiPort()).toString());
            this.apiHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_TUNNEL_HOST", this.apiHost()));
            this.apiRemoteHost_$eq(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_TUNNEL_HOST", this.apiRemoteHost()));
            this.apiPort_$eq(new StringOps(Predef$.MODULE$.augmentString(com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_TUNNEL_PORT", Integer.toString(this.apiPort())))).toInt());
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(35).append("Init: effective api host = ").append(this.apiHost()).append(" port = ").append(this.apiPort()).toString());
            this.apiURL_$eq(new StringBuilder(4).append(this.apiProtocol()).append("://").append(this.apiHost()).append(":").append(this.apiPort()).toString());
            this.apiRemoteURL_$eq(new StringBuilder(4).append(this.apiProtocol()).append("://").append(this.apiRemoteHost()).append(":").append(this.apiPort()).toString());
            return;
        }
    }

    public <T> T executeCommand(String command, Map<String, String> args, String apiTicket, ClassTag<T> ct) {
        this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(38).append("executeCommand: command=").append(command).append(" classTag=").append(ct).append(" on ").append(this.apiURL()).toString());
        Seq formArgs = args == null ? (Seq)Nil$.MODULE$ : ((TraversableOnce)args.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (Seq)new .colon.colon((Object)k, (List)new .colon.colon((Object)v, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return package$.MODULE$.tryWith(new TicketBasedIntercomAPIClient(this.apiURL(), this.apiServerCert(), apiTicket), (Function1 & Serializable & scala.Serializable)apiClient -> apiClient.postFormToJSON(new StringBuilder(2).append(MODULE$.apiPath()).append("/").append(command).append("/").toString(), ct.runtimeClass(), (Object[])formArgs.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public <T> T executeCommand(String command, Map<String, String> args, byte[] file, String fileName, String apiTicket, ClassTag<T> ct) {
        this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(38).append("executeCommand: command=").append(command).append(" classTag=").append(ct).append(" on ").append(this.apiURL()).toString());
        Seq formArgs = args == null ? (Seq)Nil$.MODULE$ : ((TraversableOnce)args.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (Seq)new .colon.colon((Object)k, (List)new .colon.colon((Object)v, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return package$.MODULE$.tryWith(new TicketBasedIntercomAPIClient(this.apiURL(), this.apiServerCert(), apiTicket), (Function1 & Serializable & scala.Serializable)apiClient -> apiClient.postFormAndFileToJSON(new StringBuilder(2).append(MODULE$.apiPath()).append("/").append(command).append("/").toString(), ct.runtimeClass(), file, fileName, (Object[])formArgs.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public InputStream executeCommandToStream(String command, Map<String, String> args, String apiTicket) {
        this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(28).append("executeCommand: command=").append(command).append(" on ").append(this.apiURL()).toString());
        Seq formArgs = args == null ? (Seq)Nil$.MODULE$ : ((TraversableOnce)args.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (Seq)new .colon.colon((Object)k, (List)new .colon.colon((Object)v, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (InputStream)package$.MODULE$.tryWith(new TicketBasedIntercomAPIClient(this.apiURL(), this.apiServerCert(), apiTicket), (Function1 & Serializable & scala.Serializable)apiClient -> {
            HttpEntity entity = apiClient.postFormToStream(new StringBuilder(2).append(MODULE$.apiPath()).append("/").append(command).append("/").toString(), (Object[])formArgs.toArray(ClassTag$.MODULE$.apply(String.class)));
            return entity.getContent();
        });
    }

    public void executeCommandFromStream(String command, Map<String, String> args, InputStream data, String apiTicket) {
        this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(28).append("executeCommand: command=").append(command).append(" on ").append(this.apiURL()).toString());
        String formArgs = args == null ? "" : new StringBuilder(1).append("?").append(((TraversableOnce)args.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (Seq)new .colon.colon((Object)new StringBuilder(1).append(k).append("=").append(URLEncoder.encode(v, "utf-8")).toString(), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().mkString("&")).toString();
        package$.MODULE$.tryWith(new TicketBasedIntercomAPIClient(this.apiURL(), this.apiServerCert(), apiTicket), (Function1 & Serializable & scala.Serializable)apiClient -> (Void)apiClient.postAnyToJSON(new StringBuilder(2).append(MODULE$.apiPath()).append("/").append(command).append("/").append(formArgs).toString(), Void.class, (HttpEntity)new InputStreamEntity(data, -1L)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHDFSCompatible(SamplingParam sampling) {
        if (sampling == null) return true;
        SamplingParam.SamplingMethod samplingMethod = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod2 = SamplingParam.SamplingMethod.FULL;
        if (samplingMethod == null) {
            if (samplingMethod2 == null) return true;
        } else if (samplingMethod.equals(samplingMethod2)) return true;
        SamplingParam.SamplingMethod samplingMethod3 = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod4 = SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
        if (samplingMethod3 != null) {
            if (!samplingMethod3.equals(samplingMethod4)) return false;
            return true;
        }
        if (samplingMethod4 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDeltaCompatible(SamplingParam sampling) {
        if (sampling == null) return true;
        SamplingParam.SamplingMethod samplingMethod = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod2 = SamplingParam.SamplingMethod.FULL;
        if (samplingMethod == null) {
            if (samplingMethod2 == null) return true;
        } else if (samplingMethod.equals(samplingMethod2)) return true;
        SamplingParam.SamplingMethod samplingMethod3 = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod4 = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        if (samplingMethod3 == null) {
            if (samplingMethod4 == null) return true;
        } else if (samplingMethod3.equals(samplingMethod4)) return true;
        SamplingParam.SamplingMethod samplingMethod5 = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod6 = SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
        if (samplingMethod5 != null) {
            if (!samplingMethod5.equals(samplingMethod6)) return false;
            return true;
        }
        if (samplingMethod6 == null) return true;
        return false;
    }

    public <M> RDD<M> sampleHDFS(RDD<M> rdd, SamplingParam sampling) {
        block5: {
            block4: {
                if (sampling == null) break block4;
                SamplingParam.SamplingMethod samplingMethod = sampling.samplingMethod;
                SamplingParam.SamplingMethod samplingMethod2 = SamplingParam.SamplingMethod.FULL;
                if (samplingMethod != null ? !samplingMethod.equals(samplingMethod2) : samplingMethod2 != null) break block5;
            }
            return rdd;
        }
        SamplingParam.SamplingMethod samplingMethod = sampling.samplingMethod;
        SamplingParam.SamplingMethod samplingMethod3 = SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
        if (!(samplingMethod != null ? !samplingMethod.equals(samplingMethod3) : samplingMethod3 != null)) {
            return rdd.sample(false, sampling.targetRatio, rdd.sample$default$3());
        }
        throw new UnsupportedOperationException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)sampling.samplingMethod), " sampling not supported on HDFS"));
    }

    public boolean isCsvDataset(Dataset dataset) {
        String string = CSVFormatExtractor.META.getType();
        String string2 = dataset.getFormatType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isJsonDataset(Dataset dataset) {
        String string = JSONFormatExtractor.META.getType();
        String string2 = dataset.getFormatType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isParquetDataset(Dataset dataset) {
        String string = ParquetFormatMeta.META.getType();
        String string2 = dataset.getFormatType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isORCDataset(Dataset dataset) {
        String string = ORCFileFormatMeta.META.getType();
        String string2 = dataset.getFormatType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isDeltaDataset(Dataset dataset) {
        String string = DeltaFormat.META.getType();
        String string2 = dataset.getFormatType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isSnowflakeInputSchemaInferrenceEnabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.allow.native.snowflake.reader.infer";
            value = ctx.sparkContext().getConf().getBoolean(key, false);
            if (!value) break block0;
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Native Snowflake reader schema inferrence enabled");
        }
        return value;
    }

    public boolean isIcebergInputSchemaInferrenceEnabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.allow.native.iceberg.reader.infer";
            value = ctx.sparkContext().getConf().getBoolean(key, false);
            if (!value) break block0;
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Native Iceberg reader schema inferrence enabled");
        }
        return value;
    }

    public boolean isSQLInputSchemaInferrenceEnabled(SQLContext ctx, String connectionName) {
        boolean valueByConn;
        block1: {
            String key = "spark.dku.allow.native.sql.reader.infer";
            boolean value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (value) {
                this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Native SQL reader schema inferrence enabled");
                return true;
            }
            String keyByConn = new StringBuilder(40).append("spark.dku.allow.native.sql.").append(connectionName).append(".reader.infer").toString();
            valueByConn = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(keyByConn, "false"))).toBoolean();
            if (!valueByConn) break block1;
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)new StringBuilder(59).append("Native SQL reader schema inferrence enabled for connection ").append(connectionName).toString());
        }
        return valueByConn;
    }

    public boolean isParquetInputSchemaInferrenceEnabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.allow.native.parquet.reader.infer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Native Parquet reader schema inferrence enabled");
        }
        return value;
    }

    public boolean isORCInputSchemaInferrenceEnabled(SQLContext ctx) {
        boolean value;
        block0: {
            String key = "spark.dku.allow.native.orc.reader.infer";
            value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "false"))).toBoolean();
            if (!value) break block0;
            this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Native ORC reader schema inferrence enabled");
        }
        return value;
    }

    public Schema datasetStoredSchema(Dataset dataset) {
        Schema schema = dataset.getSchema();
        Predef$.MODULE$.require(schema != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("dataset ").append(dataset.getFullName()).append(" does not have a schema").toString());
        return schema;
    }

    public boolean arePathsOrcCompatible(SQLContext sqlContext, Dataset dataset, List<String> partitions) {
        if (sqlContext.sparkContext().version().compareTo("2.") >= 0 && sqlContext.sparkContext().version().compareTo("2.3") < 0) {
            boolean hasPathsWithSpecialChars;
            HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
            Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories((HDFSableDatasetHandler)handler, partitions);
            boolean bl = hasPathsWithSpecialChars = !((SeqLike)paths.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)StdDataikuSparkContext$.$anonfun$arePathsOrcCompatible$1(p)))).isEmpty();
            if (hasPathsWithSpecialChars) {
                this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger().info((Object)"Some paths of the dataset contain special characters, and Spark versions is in [2.0, 2.3[, deactivating native Orc read");
            }
            return !hasPathsWithSpecialChars;
        }
        return true;
    }

    public Logger com$dataiku$dip$spark$StdDataikuSparkContext$$logger() {
        return this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger;
    }

    public static final /* synthetic */ boolean $anonfun$arePathsOrcCompatible$1(String p) {
        return !p.equals(new Path(p).toUri().toString());
    }

    private StdDataikuSparkContext$() {
        MODULE$ = this;
        this.initializedHostPort = false;
        this.flowSpec = null;
        this.apiPath = null;
        this.apiHost = null;
        this.apiRemoteHost = null;
        this.apiPort = 0;
        this.apiProtocol = null;
        this.apiURL = null;
        this.apiRemoteURL = null;
        this.apiServerCert = null;
        this.activityId = null;
        this.com$dataiku$dip$spark$StdDataikuSparkContext$$logger = Logger.getLogger((String)"dku.spark.context");
    }
}

