/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import java.util.HashMap;
import java.util.Map;

public class Gender
extends AbstractAnumMeaning {
    private static Map<String, ValidGender> data = new HashMap<String, ValidGender>();

    public String parse(String v) {
        if (v == null) {
            throw new NumberFormatException("Invalid gender data " + v);
        }
        ValidGender vb = data.get(v.toLowerCase());
        if (vb == null) {
            throw new NumberFormatException("Invalid gender data " + v);
        }
        return vb.val;
    }

    public ValidGender parseNoFail(String v) {
        if (v == null) {
            return null;
        }
        ValidGender vb = data.get(v.toLowerCase());
        if (vb == null) {
            return null;
        }
        return vb;
    }

    @Override
    public double detects(String v) {
        if (v == null || v.isEmpty()) {
            return 0.0;
        }
        ValidGender vb = data.get(v.toLowerCase());
        if (vb == null) {
            return 0.0;
        }
        return vb.score;
    }

    static {
        data.put("m", new ValidGender("male", 0.7, false));
        data.put("f", new ValidGender("female", 0.7, true));
        data.put("male", new ValidGender("male", 0.7, false));
        data.put("female", new ValidGender("female", 0.7, true));
        data.put("h", new ValidGender("male", 0.3, false));
    }

    public static class ValidGender {
        String val;
        double score;
        public boolean isFemale;

        ValidGender(String val, double score, boolean isFemale) {
            this.val = val;
            this.score = score;
            this.isFemale = isFemale;
        }
    }
}

