/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.CheckInfraReadPermissionResponse;
import com.dataiku.dip.deployer.common.datamodel.config.PublishedItem;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentActionsService;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.deployer.common.infra.DeploymentInfrasDAO;
import com.dataiku.dip.deployer.common.published.AbstractPublishedItemsService;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PublicAPIDeployerControllerBase
extends PublicAPIControllerBase {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected MetaAuthService authService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected AuditTrailService auditTrailService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    protected DeploymentActionsService deploymentActionsService;
    private final String deploymentType;
    private final String publishedItemType;

    abstract AbstractDeploymentsService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra> getDeploymentsService();

    abstract AbstractPublishedItemsService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra> getPublishedItemsService();

    abstract AbstractInfrasService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra> getInfrasService();

    abstract DeploymentInfrasDAO<? extends AbstractDeploymentInfra> getInfrasDAO();

    abstract boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus var1);

    void checkLicense() throws LicenseRestrictionException {
        LicenseStatusService.LicensingStatus licenseStatus = this.licenseStatusService.getLicensingStatus();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures = this.licenseEnforcementService.getFeaturesStatus();
        if (!this.hasLicenseFlag(licenseFeatures) && !licenseStatus.ceEntrepriseTrial) {
            throw new LicenseRestrictionException(this.deploymentType + " Deployer is not available in your license");
        }
    }

    PublicAPIDeployerControllerBase(String deploymentType, String publishedItemType) {
        this.deploymentType = deploymentType;
        this.publishedItemType = publishedItemType;
    }

    void listDeployments(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().listLightStatusUnsafe_NT_Check(authCtx));
    }

    void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().getLightStatusMandatoryUnsafe_NT_Check(deploymentId, authCtx));
    }

    void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, String deploymentId, boolean ignorePreDeleteErrors) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        AbstractDeploymentsService.DeploymentDeletionReport ret = this.getDeploymentsService().delete_NT_Check(this.deploymentType, deploymentId, authCtx, ignorePreDeleteErrors);
        if (ret.hasFailure()) {
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AbstractDeployment deploymentSettings = this.getDeploymentsService().getSettingsMandatory_Check(deploymentId, authCtx);
            if (deploymentSettings instanceof AbstractAPIServiceDeployment) {
                ((AbstractAPIServiceDeployment)deploymentSettings).auth.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)deploymentSettings);
        }
    }

    void listItems(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getPublishedItemsService().listLightStatusUnsafe_NT_Check(authCtx));
    }

    @AuditInline
    void createItem(HttpServletRequest req, HttpServletResponse resp, String publishedItemId) throws Exception {
        PublishedItem item;
        this.checkLicense();
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.getPublishedItemsService().createPublishedItem_Check(publishedItemId, publishedItemId, t.getUser());
            item = this.getPublishedItemsService().getPublishedItemSettingsMandatoryUnsafe_Check(publishedItemId, t.getUser());
            t.commitV("Created published %s: %s", new Object[]{this.publishedItemType.toLowerCase(), publishedItemId});
            this.auditTrailService.generic(String.format("%sdeployer-%s-create", this.deploymentType.toLowerCase(), this.publishedItemType.toLowerCase())).with(String.format("published%sId", this.publishedItemType), publishedItemId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure(String.format("%sdeployer-%s-create", this.deploymentType.toLowerCase(), this.publishedItemType.toLowerCase()), (Throwable)e).with(String.format("published%sId", this.publishedItemType), publishedItemId).emit();
            throw e;
        }
        PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)item);
    }

    void deleteItem(AuthCtx user, String publishedItemId) throws Exception {
        this.getPublishedItemsService().deletePublishedItem_NT_Check(publishedItemId, user);
    }

    void getItemLightStatus(HttpServletRequest req, HttpServletResponse resp, String publishedItemId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getPublishedItemsService().getPublishedItemLightStatusUnsafe_NT_Check(publishedItemId, authCtx));
    }

    void getItemSettings(HttpServletRequest req, HttpServletResponse resp, String publishedItemId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getPublishedItemsService().getPublishedItemSettingsMandatoryUnsafe_Check(publishedItemId, authCtx));
        }
    }

    void saveItemSettings(HttpServletRequest req, HttpServletResponse resp, String publishedItemId) throws Exception {
        PublishedItem d = (PublishedItem)this.getRequestBodyAs(req, PublishedItem.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.getPublishedItemsService().savePublishedItem_Check(d, t.getUser());
            t.commitV("Updated settings of published %s: %s ", new Object[]{this.publishedItemType.toLowerCase(), publishedItemId});
        }
    }

    void listInfras(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getInfrasService().listLightStatusUnsafe_Check(authCtx));
        }
    }

    void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getInfrasService().getSettingsMandatoryUnsafe_CheckAdminAndHooks(infraId, authCtx));
        }
    }

    void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)this.getInfrasService().getLightStatusUnsafe_Check(infraId, authCtx));
        }
    }

    void checkInfraReadPermission(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AbstractDeploymentInfra infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(infraId);
            CheckInfraReadPermissionResponse response = new CheckInfraReadPermissionResponse(AbstractInfrasService.hasReadPermission((AbstractDeploymentInfra)infra, (AuthCtx)authCtx));
            PublicAPIDeployerControllerBase.writeJSON((HttpServletResponse)resp, (Object)response);
        }
    }

    void deleteInfra(HttpServletRequest req, String infraId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AbstractDeploymentInfra infra = this.getInfrasService().getSettingsMandatoryUnsafe_CheckAdmin(infraId, t.getUser());
            this.getInfrasService().delete(infra);
            t.commitV("Deleted %s infra: %s", new Object[]{JSON.getType((Object)infra), infraId});
        }
    }
}

