/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.docextraction.DocExtractionService;
import com.dataiku.dip.docextraction.Extractor;
import com.dataiku.dip.docextraction.PdfConverter;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.TextExtractionResponseOrError;
import com.dataiku.dip.docextraction.common.chunks.TextChunk;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PublicAPIDocExtractorController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DocExtractionService docExtractionService;

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/vlm"}, method={RequestMethod.POST})
    public TextExtractionResponseOrError runVLMExtractor(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        Extractor.Request.VLM request = (Extractor.Request.VLM)this.getRequestBodyAs(req, Extractor.Request.VLM.class);
        if (request.settings.llmPrompt == null) {
            request.settings.llmPrompt = Extractor.getSummaryExtractionPrompt(null);
        }
        this.require(request.settings.llmId != null, "LLM ID is required to run VLM extraction");
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            List vlmChunks = this.docExtractionService.runVLMextractor(authCtx, projectKey, request);
            List<TextChunk> textChunks = vlmChunks.stream().map(vlmChunk -> TextChunk.build((String)vlmChunk.promptOutput, null)).toList();
            this.auditTrailService.generic("docextract-extract-vlm").with("llmId", request.settings.llmId).with("windowSize", (Number)request.settings.windowSize).with("windowOverlap", (Number)request.settings.windowOverlap).emit();
            return TextExtractionResponseOrError.fromSuccess(textChunks);
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-extract-vlm", (Throwable)e).with("projectKey", projectKey).with("llmId", request.settings.llmId).with("windowSize", (Number)request.settings.windowSize).with("windowOverlap", (Number)request.settings.windowOverlap).emit();
            return TextExtractionResponseOrError.fromError((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/text"}, method={RequestMethod.POST})
    public Extractor.ResponseOrError.TextFirstResponseDTO runTextExtractor(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart) throws Exception {
        Extractor.Request.RawText rawTextExtractorRequest = this.parseRequest(req, "extractionRequest", Extractor.Request.RawText.class);
        try {
            Extractor.ResponseOrError.Tree res;
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            this.require(rawTextExtractorRequest.inputs.document != null, "Input document should not be null");
            if (filePart != null) {
                InputRefs.DocumentRef documentRef = rawTextExtractorRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.LocalFileDocumentRef)) throw new IllegalArgumentException("If the request contains a multipart file, the input document ref should be LocalFileDocumentRef and not: " + rawTextExtractorRequest.inputs.document.getClass().getName());
                InputRefs.LocalFileDocumentRef localFileDocumentRef = (InputRefs.LocalFileDocumentRef)documentRef;
                localFileDocumentRef.multipartFile = filePart;
                res = this.docExtractionService.runExtractorFromLocalFileDocumentRef(authCtx, projectKey, localFileDocumentRef, false, rawTextExtractorRequest.settings);
            } else {
                InputRefs.DocumentRef documentRef = rawTextExtractorRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.ManagedFolderDocumentRef)) throw new IllegalArgumentException("Document ref: " + rawTextExtractorRequest.inputs.document.getClass().getName() + " is not supported");
                InputRefs.ManagedFolderDocumentRef documentRef2 = (InputRefs.ManagedFolderDocumentRef)documentRef;
                res = this.docExtractionService.runExtractorFromManagedFolderDocumentRef(authCtx, projectKey, documentRef2, false, rawTextExtractorRequest.settings);
            }
            this.auditTrailService.generic("docextract-extract-text").with("projectKey", projectKey).emit();
            return res.toDTO(false);
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-extract-text", (Throwable)e).with("projectKey", projectKey).emit();
            return Extractor.ResponseOrError.Tree.fromError((Throwable)e).toDTO(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/structured"}, method={RequestMethod.POST})
    public Extractor.ResponseOrError.TextFirstResponseDTO runStructuredExtractor(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart) throws Exception {
        Extractor.Request.Structured structuredExtractorRequest = this.parseRequest(req, "extractionRequest", Extractor.Request.Structured.class);
        try {
            Extractor.ResponseOrError.Tree res;
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            this.require(structuredExtractorRequest.inputs.document != null, "Input document should not be null");
            if (filePart != null) {
                InputRefs.DocumentRef documentRef = structuredExtractorRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.LocalFileDocumentRef)) throw new IllegalArgumentException("If the request contains a multipart file, the input document ref should be LocalFileDocumentRef and not: " + structuredExtractorRequest.inputs.document.getClass().getName());
                InputRefs.LocalFileDocumentRef localFileDocumentRef = (InputRefs.LocalFileDocumentRef)documentRef;
                localFileDocumentRef.multipartFile = filePart;
                res = this.docExtractionService.runExtractorFromLocalFileDocumentRef(authCtx, projectKey, localFileDocumentRef, true, (Extractor.Settings.TextFirst)structuredExtractorRequest.settings);
            } else {
                InputRefs.DocumentRef documentRef = structuredExtractorRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.ManagedFolderDocumentRef)) throw new IllegalArgumentException("Document ref: " + structuredExtractorRequest.inputs.document.getClass().getName() + " is not supported");
                InputRefs.ManagedFolderDocumentRef documentRef2 = (InputRefs.ManagedFolderDocumentRef)documentRef;
                res = this.docExtractionService.runExtractorFromManagedFolderDocumentRef(authCtx, projectKey, documentRef2, true, (Extractor.Settings.TextFirst)structuredExtractorRequest.settings);
            }
            this.auditTrailService.generic("docextract-extract-structured").with("projectKey", projectKey).with("maxSectionDepth", (Number)structuredExtractorRequest.settings.maxSectionDepth).emit();
            return res.toDTO(false);
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-extract-structured", (Throwable)e).with("projectKey", projectKey).with("maxSectionDepth", (Number)structuredExtractorRequest.settings.maxSectionDepth).emit();
            return Extractor.ResponseOrError.Tree.fromError((Throwable)e).toDTO(false);
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/convert/to-pdf/download"}, method={RequestMethod.POST})
    public void runPDFConverterAndDownload(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart) throws Exception {
        PdfConverter.PDFConverterRequest pdfConverterRequest = this.parseRequest(req, "conversionRequest", PdfConverter.PDFConverterRequest.class);
        this.require(pdfConverterRequest.inputs.document != null, "Input document should not be null");
        String fileName = filePart != null ? filePart.getOriginalFilename() : (String)Optional.ofNullable(pdfConverterRequest.inputs).map(i -> i.document).map(InputRefs.DocumentRef::getFilePath).orElse(null);
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            File file = this.docExtractionService.runPDFConversionFromDocumentRef(authCtx, projectKey, filePart, pdfConverterRequest);
            this.writeStream(resp, DKUFileUtils.readWithAutoDecompress((File)file), MimeTypeUtils.fromExtension((String)"pdf").mimeType, file.getName());
            this.auditTrailService.generic("docextract-to-pdf-download").with("projectKey", projectKey).with("fileName", fileName).with("outputManagedFolderId", pdfConverterRequest.outputManagedFolderRef).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-to-pdf-download", (Throwable)e).with("projectKey", projectKey).with("fileName", fileName).with("outputManagedFolderId", pdfConverterRequest.outputManagedFolderRef).emit();
            throw e;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/convert/to-pdf"}, method={RequestMethod.POST})
    public PdfConverter.PDFConverterResponseOrError runPDFConverter(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart) throws Exception {
        PdfConverter.PDFConverterRequest pdfConverterRequest = this.parseRequest(req, "conversionRequest", PdfConverter.PDFConverterRequest.class);
        this.require(pdfConverterRequest.inputs.document != null, "Input document should not be null");
        this.require(StringUtils.isNotBlank((String)pdfConverterRequest.outputManagedFolderRef), "outputManagedFolderRef is required when writing the output file to a managed folder, use convert/to-pdf/download endpoint to download directly");
        String fileName = filePart != null ? filePart.getOriginalFilename() : (String)Optional.ofNullable(pdfConverterRequest.inputs).map(i -> i.document).map(InputRefs.DocumentRef::getFilePath).orElse(null);
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, true);
            PdfConverter.PDFConverterResponseOrError res = this.docExtractionService.runPDFConversionFromDocumentRefAndWriteOutputFileToManagedFolder(authCtx, projectKey, pdfConverterRequest.inputs.document, filePart, pdfConverterRequest);
            if (res.ok) {
                this.auditTrailService.generic("docextract-to-pdf").with("projectKey", projectKey).with("fileName", fileName).with("outputManagedFolderId", pdfConverterRequest.outputManagedFolderRef).emit();
            } else {
                this.auditTrailService.failure("docextract-to-pdf", res.throwable).with("projectKey", projectKey).with("fileName", fileName).with("outputManagedFolderId", pdfConverterRequest.outputManagedFolderRef).emit();
            }
            return res;
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-to-pdf", (Throwable)e).with("projectKey", projectKey).with("fileName", fileName).with("outputManagedFolderId", pdfConverterRequest.outputManagedFolderRef).emit();
            return PdfConverter.PDFConverterResponseOrError.fromError((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/screenshotter"}, method={RequestMethod.POST})
    public Screenshotter.ScreenshotterResponseOrError runScreenshotter(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart) throws Exception {
        Screenshotter.ScreenshotterRequest screenshotterRequest = this.parseRequest(req, "screenshotRequest", Screenshotter.ScreenshotterRequest.class);
        try {
            Screenshotter.ScreenshotterResponseOrError res;
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, screenshotterRequest.settings.outputManagedFolderId != null);
            if (filePart != null) {
                InputRefs.DocumentRef documentRef = screenshotterRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.LocalFileDocumentRef)) throw new IllegalArgumentException("If the request contains a multipart file, the input document Ref should be LocalFileDocumentRef");
                InputRefs.LocalFileDocumentRef localFileDocumentRef = (InputRefs.LocalFileDocumentRef)documentRef;
                localFileDocumentRef.multipartFile = filePart;
                res = this.docExtractionService.extractScreenshotsFromLocalFileDocumentRef(authCtx, projectKey, localFileDocumentRef, screenshotterRequest.settings);
            } else {
                InputRefs.DocumentRef documentRef = screenshotterRequest.inputs.document;
                if (documentRef instanceof InputRefs.ManagedFolderDocumentRef) {
                    InputRefs.ManagedFolderDocumentRef managedFolderDocumentRef = (InputRefs.ManagedFolderDocumentRef)documentRef;
                    res = this.docExtractionService.extractScreenshotsFromManagedFolderDocumentRef(authCtx, projectKey, managedFolderDocumentRef, screenshotterRequest.settings);
                } else {
                    documentRef = screenshotterRequest.inputs.document;
                    if (!(documentRef instanceof InputRefs.TmpDocumentRef)) throw new IllegalArgumentException("Document ref is not supported");
                    InputRefs.TmpDocumentRef tmpDocumentRef = (InputRefs.TmpDocumentRef)documentRef;
                    res = this.docExtractionService.extractScreenshotsFromTmpDocumentRef(authCtx, projectKey, tmpDocumentRef, screenshotterRequest.settings);
                }
            }
            if (res.ok) {
                this.auditTrailService.generic("docextract-screenshot").with("lastResultIndex", (Number)res.lastResultIndex).with("hasMoreResults", res.hasMoreResults).with("totalResults", (Number)res.totalResults).emit();
                return res;
            } else {
                this.auditTrailService.failure("docextract-screenshot", res.throwable).with("projectKey", projectKey).emit();
            }
            return res;
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-screenshot", (Throwable)e).with("projectKey", projectKey).emit();
            return Screenshotter.ScreenshotterResponseOrError.fromError((Throwable)e);
        }
    }

    private AuthCtx authAndCheckAccessAndSetCRUContext(HttpServletRequest req, String projectKey, boolean areWritePermissionsNeeded) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            if (areWritePermissionsNeeded) {
                this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsage((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    private <T> T parseRequest(HttpServletRequest req, String parameterName, Class<T> clazz) {
        Object request;
        String[] parameterValues = req.getParameterValues(parameterName);
        if (parameterValues == null || parameterValues.length == 0) {
            parameterValues = req.getParameterValues("json");
        }
        try {
            request = JSON.parse((String)parameterValues[0], clazz);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected parameter: " + parameterName, e);
        }
        return (T)request;
    }
}

