/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class LobConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(LobConverterFactory.class);

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (byte[].class.equals(target) && Blob.class.isAssignableFrom(source)) {
            return new BlobConverter();
        }
        if (String.class.equals(target) && Clob.class.isAssignableFrom(source)) {
            return new ClobConverter();
        }
        return null;
    }

    private static class ClobConverter
    implements Converter {
        private ClobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            String s;
            if (source == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            Clob clob = (Clob)source;
            try {
                s = this.fullFetch(clob);
            }
            catch (SQLFeatureNotSupportedException e) {
                s = this.chunkwiseFetch(clob);
            }
            return target.cast(s);
        }

        private String fullFetch(Clob clob) throws SQLException {
            long length = clob.length();
            if (length == 0L) {
                return "";
            }
            if (length > Integer.MAX_VALUE) {
                LOGGER.fine("Clob has size " + length + ", which is too large for a string");
                return null;
            }
            int clength = (int)length;
            return clob.getSubString(1L, clength);
        }

        private String chunkwiseFetch(Clob clob) throws SQLException, IOException {
            try (Reader reader = clob.getCharacterStream();){
                int charsRead;
                StringWriter writer = new StringWriter();
                char[] buffer = new char[4096];
                while ((charsRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, charsRead);
                }
                String string = writer.toString();
                return string;
            }
        }
    }

    private static class BlobConverter
    implements Converter {
        private BlobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            byte[] data;
            if (source == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            Blob blob = (Blob)source;
            try {
                data = this.fullFetch(blob);
            }
            catch (SQLFeatureNotSupportedException e) {
                data = this.chunkwiseFetch(blob);
            }
            return target.cast(data);
        }

        private byte[] fullFetch(Blob blob) throws SQLException {
            long length = blob.length();
            if (length == 0L) {
                return new byte[0];
            }
            if (length > Integer.MAX_VALUE) {
                LOGGER.fine("Blob has size " + length + ", which is too large for a byte array");
                return null;
            }
            int clength = (int)length;
            return blob.getBytes(1L, clength);
        }

        private byte[] chunkwiseFetch(Blob blob) throws SQLException, IOException {
            try (InputStream is = blob.getBinaryStream();){
                int bytesRead;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
    }
}

