/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.text.ParseException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class BranchNormalizedVisitor
implements FilterVisitor {
    @Override
    public Object visit(ExprNode node) {
        if (!(node instanceof BranchNode)) {
            return null;
        }
        BranchNode branch = (BranchNode)node;
        NodeComparator nodeComparator = new NodeComparator();
        TreeSet<ExprNode> set = new TreeSet<ExprNode>(nodeComparator);
        List<ExprNode> children = branch.getChildren();
        for (ExprNode child : branch.getChildren()) {
            if (!child.isLeaf()) {
                ExprNode newChild = (ExprNode)this.visit(child);
                if (newChild == null) continue;
                set.add(newChild);
                continue;
            }
            set.add(child);
        }
        children.clear();
        children.addAll(set);
        return branch;
    }

    @Override
    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    @Override
    public boolean isPrefix() {
        return false;
    }

    @Override
    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }

    public static String getNormalizedFilter(SchemaManager schemaManager, String filter) throws ParseException {
        ExprNode originalNode = FilterParser.parse(schemaManager, filter);
        return BranchNormalizedVisitor.getNormalizedFilter(originalNode);
    }

    public static String getNormalizedFilter(ExprNode filter) {
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        ExprNode result = (ExprNode)visitor.visit(filter);
        return result.toString().trim();
    }

    static class NodeComparator
    implements Comparator<ExprNode> {
        NodeComparator() {
        }

        @Override
        public int compare(ExprNode o1, ExprNode o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }
}

