/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.hc.client5.http.impl.compat;

import com.dataiku.dss.shadelib.org.apache.hc.client5.http.impl.compat.ClassicToAsyncSupport;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.impl.compat.SharedOutputBuffer;
import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.Experimental;
import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.Internal;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ClassicHttpRequest;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpException;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.nio.DataStreamChannel;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.nio.RequestChannel;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Args;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Asserts;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
@Internal
class ClassicToAsyncRequestProducer
implements AsyncRequestProducer {
    private final ClassicHttpRequest request;
    private final int initialBufferSize;
    private final Timeout timeout;
    private final CountDownLatch countDownLatch;
    private final AtomicReference<SharedOutputBuffer> bufferRef;
    private final AtomicReference<Exception> exceptionRef;
    private volatile boolean repeatable;

    public ClassicToAsyncRequestProducer(ClassicHttpRequest request, int initialBufferSize, Timeout timeout) {
        this.request = Args.notNull(request, "HTTP request");
        this.initialBufferSize = Args.positive(initialBufferSize, "Initial buffer size");
        this.timeout = timeout;
        this.countDownLatch = new CountDownLatch(1);
        this.bufferRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    public ClassicToAsyncRequestProducer(ClassicHttpRequest request, Timeout timeout) {
        this(request, 2048, timeout);
    }

    void propagateException() throws IOException {
        Exception ex = this.exceptionRef.getAndSet(null);
        if (ex != null) {
            ClassicToAsyncSupport.rethrow(ex);
        }
    }

    public IORunnable blockWaiting() throws IOException, InterruptedException {
        if (this.timeout == null) {
            this.countDownLatch.await();
        } else if (!this.countDownLatch.await(this.timeout.getDuration(), this.timeout.getTimeUnit())) {
            throw new InterruptedIOException("Timeout blocked waiting for output (" + this.timeout + ")");
        }
        this.propagateException();
        SharedOutputBuffer outputBuffer = this.bufferRef.get();
        return () -> {
            HttpEntity requestEntity = this.request.getEntity();
            if (requestEntity != null) {
                try (InternalOutputStream outputStream = new InternalOutputStream(outputBuffer);){
                    requestEntity.writeTo(outputStream);
                }
            }
        };
    }

    @Override
    public void sendRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
        HttpEntity requestEntity = this.request.getEntity();
        SharedOutputBuffer buffer = requestEntity != null ? new SharedOutputBuffer(this.initialBufferSize) : null;
        this.bufferRef.set(buffer);
        this.repeatable = requestEntity == null || requestEntity.isRepeatable();
        channel.sendRequest(this.request, requestEntity, null);
        this.countDownLatch.countDown();
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public int available() {
        SharedOutputBuffer buffer = this.bufferRef.get();
        if (buffer != null) {
            return buffer.length();
        }
        return 0;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        SharedOutputBuffer buffer = this.bufferRef.get();
        if (buffer != null) {
            buffer.flush(channel);
        }
    }

    @Override
    public void failed(Exception cause) {
        try {
            this.exceptionRef.set(cause);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void releaseResources() {
    }

    class InternalOutputStream
    extends OutputStream {
        private final SharedOutputBuffer buffer;

        public InternalOutputStream(SharedOutputBuffer buffer) {
            Asserts.notNull(buffer, "Shared buffer");
            this.buffer = buffer;
        }

        @Override
        public void close() throws IOException {
            ClassicToAsyncRequestProducer.this.propagateException();
            this.buffer.writeCompleted(ClassicToAsyncRequestProducer.this.timeout);
        }

        @Override
        public void flush() throws IOException {
            ClassicToAsyncRequestProducer.this.propagateException();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ClassicToAsyncRequestProducer.this.propagateException();
            this.buffer.write(b, off, len, ClassicToAsyncRequestProducer.this.timeout);
        }

        @Override
        public void write(byte[] b) throws IOException {
            ClassicToAsyncRequestProducer.this.propagateException();
            if (b == null) {
                return;
            }
            this.buffer.write(b, 0, b.length, ClassicToAsyncRequestProducer.this.timeout);
        }

        @Override
        public void write(int b) throws IOException {
            ClassicToAsyncRequestProducer.this.propagateException();
            this.buffer.write(b, ClassicToAsyncRequestProducer.this.timeout);
        }
    }

    public static interface IORunnable {
        public void execute() throws IOException;
    }
}

