/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.MergingSnapshotProducer;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CherrypickAncestorCommitException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PartitionSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.WapUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;

class CherryPickOperation
extends MergingSnapshotProducer<CherryPickOperation> {
    private final FileIO io;
    private final Map<Integer, PartitionSpec> specsById;
    private Snapshot cherrypickSnapshot = null;
    private boolean requireFastForward = false;
    private PartitionSet replacedPartitions = null;

    CherryPickOperation(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.io = ops.io();
        this.specsById = ops.current().specsById();
    }

    @Override
    protected CherryPickOperation self() {
        return this;
    }

    @Override
    protected String operation() {
        Preconditions.checkNotNull(this.cherrypickSnapshot, "[BUG] Detected uninitialized operation");
        return this.cherrypickSnapshot.operation();
    }

    public CherryPickOperation cherrypick(long snapshotId) {
        TableMetadata current = this.current();
        this.cherrypickSnapshot = current.snapshot(snapshotId);
        ValidationException.check(this.cherrypickSnapshot != null, "Cannot cherry-pick unknown snapshot ID: %s", snapshotId);
        if (this.cherrypickSnapshot.operation().equals("append")) {
            String wapId = WapUtil.validateWapPublish(current, snapshotId);
            if (wapId != null) {
                this.set("published-wap-id", wapId);
            }
            this.set("source-snapshot-id", String.valueOf(snapshotId));
            for (DataFile addedFile : this.cherrypickSnapshot.addedDataFiles(this.io)) {
                this.add(addedFile);
            }
        } else if (this.cherrypickSnapshot.operation().equals("overwrite") && PropertyUtil.propertyAsBoolean(this.cherrypickSnapshot.summary(), "replace-partitions", false)) {
            ValidationException.check(this.cherrypickSnapshot.parentId() == null || CherryPickOperation.isCurrentAncestor(current, this.cherrypickSnapshot.parentId()), "Cannot cherry-pick overwrite not based on an ancestor of the current state: %s", snapshotId);
            String wapId = WapUtil.validateWapPublish(current, snapshotId);
            if (wapId != null) {
                this.set("published-wap-id", wapId);
            }
            this.set("source-snapshot-id", String.valueOf(snapshotId));
            this.failMissingDeletePaths();
            this.replacedPartitions = PartitionSet.create(this.specsById);
            for (DataFile addedFile : this.cherrypickSnapshot.addedDataFiles(this.io)) {
                this.add(addedFile);
                this.replacedPartitions.add(addedFile.specId(), addedFile.partition());
            }
            for (DataFile deletedFile : this.cherrypickSnapshot.removedDataFiles(this.io)) {
                this.delete(deletedFile);
            }
        } else {
            ValidationException.check(this.isFastForward(current), "Cannot cherry-pick snapshot %s: not append, dynamic overwrite, or fast-forward", this.cherrypickSnapshot.snapshotId());
            this.requireFastForward = true;
        }
        return this;
    }

    @Override
    public Object updateEvent() {
        if (this.cherrypickSnapshot == null) {
            return null;
        }
        TableMetadata tableMetadata = this.refresh();
        long snapshotId = tableMetadata.currentSnapshot().snapshotId();
        if (this.cherrypickSnapshot.snapshotId() == snapshotId) {
            return null;
        }
        return super.updateEvent();
    }

    @Override
    protected void validate(TableMetadata base, Snapshot snapshot) {
        if (!this.isFastForward(base)) {
            CherryPickOperation.validateNonAncestor(base, this.cherrypickSnapshot.snapshotId());
            CherryPickOperation.validateReplacedPartitions(base, this.cherrypickSnapshot.parentId(), this.replacedPartitions, this.io);
            WapUtil.validateWapPublish(base, this.cherrypickSnapshot.snapshotId());
        }
    }

    private boolean isFastForward(TableMetadata base) {
        if (base.currentSnapshot() != null) {
            return this.cherrypickSnapshot.parentId() != null && base.currentSnapshot().snapshotId() == this.cherrypickSnapshot.parentId().longValue();
        }
        return this.cherrypickSnapshot.parentId() == null;
    }

    @Override
    public Snapshot apply() {
        TableMetadata base = this.refresh();
        if (this.cherrypickSnapshot == null) {
            return base.currentSnapshot();
        }
        boolean isFastForward = this.isFastForward(base);
        if (this.requireFastForward || isFastForward) {
            ValidationException.check(isFastForward, "Cannot cherry-pick snapshot %s: not append, dynamic overwrite, or fast-forward", this.cherrypickSnapshot.snapshotId());
            return base.snapshot(this.cherrypickSnapshot.snapshotId());
        }
        return super.apply();
    }

    private static void validateNonAncestor(TableMetadata meta, long snapshotId) {
        if (CherryPickOperation.isCurrentAncestor(meta, snapshotId)) {
            throw new CherrypickAncestorCommitException(snapshotId);
        }
        Long ancestorId = CherryPickOperation.lookupAncestorBySourceSnapshot(meta, snapshotId);
        if (ancestorId != null) {
            throw new CherrypickAncestorCommitException(snapshotId, ancestorId);
        }
    }

    private static void validateReplacedPartitions(TableMetadata meta, Long parentId, PartitionSet replacedPartitions, FileIO io) {
        if (replacedPartitions != null && meta.currentSnapshot() != null) {
            ValidationException.check(parentId == null || CherryPickOperation.isCurrentAncestor(meta, parentId), "Cannot cherry-pick overwrite, based on non-ancestor of the current state: %s", parentId);
            try (CloseableIterable<DataFile> newFiles = SnapshotUtil.newFilesBetween(parentId, meta.currentSnapshot().snapshotId(), meta::snapshot, io);){
                for (DataFile newFile : newFiles) {
                    ValidationException.check(!replacedPartitions.contains(newFile.specId(), newFile.partition()), "Cannot cherry-pick replace partitions with changed partition: %s", newFile.partition());
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Failed to validate replaced partitions", ioe);
            }
        }
    }

    private static Long lookupAncestorBySourceSnapshot(TableMetadata meta, long snapshotId) {
        String snapshotIdStr = String.valueOf(snapshotId);
        for (long ancestorId : CherryPickOperation.currentAncestors(meta)) {
            Map<String, String> summary = meta.snapshot(ancestorId).summary();
            if (summary == null || !snapshotIdStr.equals(summary.get("source-snapshot-id"))) continue;
            return ancestorId;
        }
        return null;
    }

    private static List<Long> currentAncestors(TableMetadata meta) {
        return SnapshotUtil.ancestorIds(meta.currentSnapshot(), meta::snapshot);
    }

    private static boolean isCurrentAncestor(TableMetadata meta, long snapshotId) {
        return CherryPickOperation.currentAncestors(meta).contains(snapshotId);
    }
}

