/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTaskGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import java.util.List;

abstract class DataScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
extends SnapshotScan<ThisT, T, G> {
    protected DataScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    protected boolean useSnapshotSchema() {
        return true;
    }

    protected ManifestGroup newManifestGroup(List<ManifestFile> dataManifests, List<ManifestFile> deleteManifests) {
        return this.newManifestGroup(dataManifests, deleteManifests, this.context().returnColumnStats());
    }

    protected ManifestGroup newManifestGroup(List<ManifestFile> dataManifests, boolean withColumnStats) {
        return this.newManifestGroup(dataManifests, ImmutableList.of(), withColumnStats);
    }

    protected ManifestGroup newManifestGroup(List<ManifestFile> dataManifests, List<ManifestFile> deleteManifests, boolean withColumnStats) {
        ManifestGroup manifestGroup = new ManifestGroup(this.io(), dataManifests, deleteManifests).caseSensitive(this.isCaseSensitive()).select(withColumnStats ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS).filterData(this.filter()).specsById(this.table().specs()).scanMetrics(this.scanMetrics()).ignoreDeleted().columnsToKeepStats(this.columnsToKeepStats());
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (this.shouldPlanWithExecutor() && (dataManifests.size() > 1 || deleteManifests.size() > 1)) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup;
    }
}

