/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseFileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFileParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ResidualEvaluator;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;

public class FileScanTaskParser {
    private static final String SCHEMA = "schema";
    private static final String SPEC = "spec";
    private static final String DATA_FILE = "data-file";
    private static final String START = "start";
    private static final String LENGTH = "length";
    private static final String DELETE_FILES = "delete-files";
    private static final String RESIDUAL = "residual-filter";

    private FileScanTaskParser() {
    }

    static void toJson(FileScanTask fileScanTask, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(fileScanTask != null, "Invalid file scan task: null");
        Preconditions.checkArgument(generator != null, "Invalid JSON generator: null");
        generator.writeFieldName(SCHEMA);
        SchemaParser.toJson(fileScanTask.schema(), generator);
        generator.writeFieldName(SPEC);
        PartitionSpec spec = fileScanTask.spec();
        PartitionSpecParser.toJson(spec, generator);
        if (fileScanTask.file() != null) {
            generator.writeFieldName(DATA_FILE);
            ContentFileParser.toJson(fileScanTask.file(), spec, generator);
        }
        generator.writeNumberField(START, fileScanTask.start());
        generator.writeNumberField(LENGTH, fileScanTask.length());
        if (fileScanTask.deletes() != null) {
            generator.writeArrayFieldStart(DELETE_FILES);
            for (DeleteFile deleteFile : fileScanTask.deletes()) {
                ContentFileParser.toJson(deleteFile, spec, generator);
            }
            generator.writeEndArray();
        }
        if (fileScanTask.residual() != null) {
            generator.writeFieldName(RESIDUAL);
            ExpressionParser.toJson(fileScanTask.residual(), generator);
        }
    }

    static FileScanTask fromJson(JsonNode jsonNode, boolean caseSensitive) {
        Preconditions.checkArgument(jsonNode != null, "Invalid JSON node for file scan task: null");
        Preconditions.checkArgument(jsonNode.isObject(), "Invalid JSON node for file scan task: non-object (%s)", (Object)jsonNode);
        Schema schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, jsonNode));
        String schemaString = SchemaParser.toJson(schema);
        PartitionSpec spec = PartitionSpecParser.fromJson(schema, JsonUtil.get(SPEC, jsonNode));
        String specString = PartitionSpecParser.toJson(spec);
        DataFile dataFile = null;
        if (jsonNode.has(DATA_FILE)) {
            dataFile = (DataFile)ContentFileParser.fromJson(jsonNode.get(DATA_FILE), spec);
        }
        long start = JsonUtil.getLong(START, jsonNode);
        long length = JsonUtil.getLong(LENGTH, jsonNode);
        DeleteFile[] deleteFiles = null;
        if (jsonNode.has(DELETE_FILES)) {
            JsonNode deletesArray = jsonNode.get(DELETE_FILES);
            Preconditions.checkArgument(deletesArray.isArray(), "Invalid JSON node for delete files: non-array (%s)", (Object)deletesArray);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonNode deleteFileNode : deletesArray) {
                DeleteFile deleteFile = (DeleteFile)ContentFileParser.fromJson(deleteFileNode, spec);
                builder.add(deleteFile);
            }
            deleteFiles = builder.build().toArray(new DeleteFile[0]);
        }
        Expression filter = Expressions.alwaysTrue();
        if (jsonNode.has(RESIDUAL)) {
            filter = ExpressionParser.fromJson(jsonNode.get(RESIDUAL));
        }
        ResidualEvaluator residualEvaluator = ResidualEvaluator.of(spec, filter, caseSensitive);
        BaseFileScanTask baseFileScanTask = new BaseFileScanTask(dataFile, deleteFiles, schemaString, specString, residualEvaluator);
        return new BaseFileScanTask.SplitScanTask(start, length, baseFileScanTask);
    }
}

