/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.HasTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.HistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionField;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class FindFiles {
    private FindFiles() {
    }

    public static Builder in(Table table) {
        return new Builder(table);
    }

    public static class Builder {
        private final Table table;
        private final TableOperations ops;
        private boolean caseSensitive = true;
        private boolean includeColumnStats = false;
        private Long snapshotId = null;
        private Expression rowFilter = Expressions.alwaysTrue();
        private Expression fileFilter = Expressions.alwaysTrue();
        private Expression partitionFilter = Expressions.alwaysTrue();
        private ExecutorService executorService;

        public Builder(Table table) {
            this.table = table;
            this.ops = ((HasTableOperations)((Object)table)).operations();
        }

        public Builder caseInsensitive() {
            this.caseSensitive = false;
            return this;
        }

        public Builder caseSensitive(boolean findCaseSensitive) {
            this.caseSensitive = findCaseSensitive;
            return this;
        }

        public Builder includeColumnStats() {
            this.includeColumnStats = true;
            return this;
        }

        public Builder inSnapshot(long findSnapshotId) {
            Preconditions.checkArgument(this.snapshotId == null, "Cannot set snapshot multiple times, already set to id=%s", findSnapshotId);
            Preconditions.checkArgument(this.table.snapshot(findSnapshotId) != null, "Cannot find snapshot for id=%s", findSnapshotId);
            this.snapshotId = findSnapshotId;
            return this;
        }

        public Builder asOfTime(long timestampMillis) {
            Preconditions.checkArgument(this.snapshotId == null, "Cannot set snapshot multiple times, already set to id=%s", (Object)this.snapshotId);
            Long lastSnapshotId = null;
            for (HistoryEntry logEntry : this.ops.current().snapshotLog()) {
                if (logEntry.timestampMillis() > timestampMillis) break;
                lastSnapshotId = logEntry.snapshotId();
            }
            Preconditions.checkArgument(lastSnapshotId != null, "Cannot find a snapshot older than %s", (Object)DateTimeUtil.formatTimestampMillis(timestampMillis));
            return this.inSnapshot(lastSnapshotId);
        }

        public Builder withRecordsMatching(Expression expr) {
            this.rowFilter = Expressions.and(this.rowFilter, expr);
            return this;
        }

        public Builder withMetadataMatching(Expression expr) {
            this.fileFilter = Expressions.and(this.fileFilter, expr);
            return this;
        }

        public Builder inPartition(PartitionSpec spec, StructLike partition) {
            return this.inPartitions(spec, partition);
        }

        public Builder inPartitions(PartitionSpec spec, StructLike ... partitions) {
            return this.inPartitions(spec, Arrays.asList(partitions));
        }

        public Builder inPartitions(PartitionSpec spec, List<StructLike> partitions) {
            Preconditions.checkArgument(spec.equals(this.ops.current().spec(spec.specId())), "Partition spec does not belong to table: %s", (Object)this.table);
            Expression partitionSetFilter = Expressions.alwaysFalse();
            for (StructLike partitionData : partitions) {
                Expression partFilter = Expressions.alwaysTrue();
                for (int i = 0; i < spec.fields().size(); ++i) {
                    PartitionField field = spec.fields().get(i);
                    partFilter = Expressions.and(partFilter, Expressions.equal(field.name(), partitionData.get(i, Object.class)));
                }
                partitionSetFilter = Expressions.or(partitionSetFilter, partFilter);
            }
            this.partitionFilter = this.partitionFilter != Expressions.alwaysTrue() ? Expressions.or(this.partitionFilter, partitionSetFilter) : partitionSetFilter;
            return this;
        }

        public Builder planWith(ExecutorService newExecutorService) {
            this.executorService = newExecutorService;
            return this;
        }

        public CloseableIterable<DataFile> collect() {
            Snapshot snapshot;
            Snapshot snapshot2 = snapshot = this.snapshotId != null ? this.ops.current().snapshot(this.snapshotId) : this.ops.current().currentSnapshot();
            if (snapshot == null) {
                return CloseableIterable.empty();
            }
            CloseableIterable<ManifestEntry<DataFile>> entries = new ManifestGroup(this.ops.io(), snapshot.dataManifests(this.ops.io())).specsById(this.ops.current().specsById()).filterData(this.rowFilter).filterFiles(this.fileFilter).filterPartitions(this.partitionFilter).ignoreDeleted().caseSensitive(this.caseSensitive).planWith(this.executorService).entries();
            return CloseableIterable.transform(entries, entry -> (DataFile)((DataFile)entry.file()).copy(this.includeColumnStats));
        }
    }
}

