/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.HistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StaticDataTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.StaticTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;

public class HistoryTable
extends BaseMetadataTable {
    private static final Schema HISTORY_SCHEMA = new Schema(Types.NestedField.required(1, "made_current_at", Types.TimestampType.withZone()), Types.NestedField.required(2, "snapshot_id", Types.LongType.get()), Types.NestedField.optional(3, "parent_id", Types.LongType.get()), Types.NestedField.required(4, "is_current_ancestor", Types.BooleanType.get()));

    HistoryTable(Table table) {
        this(table, table.name() + ".history");
    }

    HistoryTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new HistoryScan(this.table());
    }

    @Override
    public Schema schema() {
        return HISTORY_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.HISTORY;
    }

    private DataTask task(TableScan scan) {
        return StaticDataTask.of(this.table().io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), this.table().history(), HistoryTable.convertHistoryEntryFunc(this.table()));
    }

    private static Function<HistoryEntry, StaticDataTask.Row> convertHistoryEntryFunc(Table table) {
        HashMap<Long, Snapshot> snapshots = Maps.newHashMap();
        for (Snapshot snap : table.snapshots()) {
            snapshots.put(snap.snapshotId(), snap);
        }
        HashSet<Long> ancestorIds = Sets.newHashSet(SnapshotUtil.currentAncestorIds(table));
        return historyEntry -> {
            long snapshotId = historyEntry.snapshotId();
            Snapshot snap = (Snapshot)snapshots.get(snapshotId);
            return StaticDataTask.Row.of(historyEntry.timestampMillis() * 1000L, historyEntry.snapshotId(), snap != null ? snap.parentId() : null, ancestorIds.contains(snapshotId));
        };
    }

    private class HistoryScan
    extends StaticTableScan {
        HistoryScan(Table table) {
            super(table, HISTORY_SCHEMA, MetadataTableType.HISTORY, (StaticTableScan x$0) -> HistoryTable.this.task((TableScan)x$0));
        }

        HistoryScan(Table table, TableScanContext context) {
            super(table, HISTORY_SCHEMA, MetadataTableType.HISTORY, x$0 -> HistoryTable.this.task((TableScan)x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new HistoryScan(table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose(HistoryTable.this.task(this));
        }
    }
}

