/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileCleanupStrategy;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReachableFileCleanup
extends FileCleanupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ReachableFileCleanup.class);

    ReachableFileCleanup(FileIO fileIO, ExecutorService deleteExecutorService, ExecutorService planExecutorService, Consumer<String> deleteFunc) {
        super(fileIO, deleteExecutorService, planExecutorService, deleteFunc);
    }

    @Override
    public void cleanFiles(TableMetadata beforeExpiration, TableMetadata afterExpiration) {
        HashSet<String> manifestListsToDelete = Sets.newHashSet();
        HashSet<Snapshot> snapshotsBeforeExpiration = Sets.newHashSet(beforeExpiration.snapshots());
        HashSet<Snapshot> snapshotsAfterExpiration = Sets.newHashSet(afterExpiration.snapshots());
        HashSet<Snapshot> expiredSnapshots = Sets.newHashSet();
        for (Snapshot snapshot : snapshotsBeforeExpiration) {
            if (snapshotsAfterExpiration.contains(snapshot)) continue;
            expiredSnapshots.add(snapshot);
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        Set<ManifestFile> deletionCandidates = this.readManifests(expiredSnapshots);
        if (!deletionCandidates.isEmpty()) {
            ConcurrentHashMap.KeySetView currentManifests = ConcurrentHashMap.newKeySet();
            Set<ManifestFile> manifestsToDelete = this.pruneReferencedManifests(snapshotsAfterExpiration, deletionCandidates, currentManifests::add);
            if (!manifestsToDelete.isEmpty()) {
                Set<String> dataFilesToDelete = this.findFilesToDelete(manifestsToDelete, currentManifests);
                this.deleteFiles(dataFilesToDelete, "data");
                Set<String> manifestPathsToDelete = manifestsToDelete.stream().map(ManifestFile::path).collect(Collectors.toSet());
                this.deleteFiles(manifestPathsToDelete, "manifest");
            }
        }
        this.deleteFiles(manifestListsToDelete, "manifest list");
        if (this.hasAnyStatisticsFiles(beforeExpiration)) {
            this.deleteFiles(this.expiredStatisticsFilesLocations(beforeExpiration, afterExpiration), "statistics files");
        }
    }

    private Set<ManifestFile> pruneReferencedManifests(Set<Snapshot> snapshots, Set<ManifestFile> deletionCandidates, Consumer<ManifestFile> currentManifestCallback) {
        ConcurrentHashMap.KeySetView candidateSet = ConcurrentHashMap.newKeySet();
        candidateSet.addAll(deletionCandidates);
        Tasks.foreach(snapshots).retry(3).stopOnFailure().throwFailureWhenFinished().executeWith(this.planExecutorService).onFailure((snapshot, exc) -> LOG.warn("Failed to determine manifests for snapshot {}", (Object)snapshot.snapshotId(), (Object)exc)).run(snapshot -> {
            try (CloseableIterable<ManifestFile> manifestFiles = this.readManifests((Snapshot)snapshot);){
                for (ManifestFile manifestFile : manifestFiles) {
                    candidateSet.remove(manifestFile);
                    if (candidateSet.isEmpty()) {
                        return;
                    }
                    currentManifestCallback.accept(manifestFile.copy());
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
            }
        });
        return candidateSet;
    }

    private Set<ManifestFile> readManifests(Set<Snapshot> snapshots) {
        ConcurrentHashMap.KeySetView manifestFiles = ConcurrentHashMap.newKeySet();
        Tasks.foreach(snapshots).retry(3).stopOnFailure().throwFailureWhenFinished().executeWith(this.planExecutorService).onFailure((snapshot, exc) -> LOG.warn("Failed to determine manifests for snapshot {}", (Object)snapshot.snapshotId(), (Object)exc)).run(snapshot -> {
            try (CloseableIterable<ManifestFile> manifests = this.readManifests((Snapshot)snapshot);){
                for (ManifestFile manifestFile : manifests) {
                    manifestFiles.add(manifestFile.copy());
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
            }
        });
        return manifestFiles;
    }

    private Set<String> findFilesToDelete(Set<ManifestFile> manifestFilesToDelete, Set<ManifestFile> currentManifestFiles) {
        ConcurrentHashMap.KeySetView filesToDelete = ConcurrentHashMap.newKeySet();
        Tasks.foreach(manifestFilesToDelete).retry(3).suppressFailureWhenFinished().executeWith(this.planExecutorService).onFailure((item, exc) -> LOG.warn("Failed to determine live files in manifest {}. Retrying", (Object)item.path(), (Object)exc)).run(manifest -> {
            try (CloseableIterable<String> paths = ManifestFiles.readPaths(manifest, this.fileIO);){
                paths.forEach(filesToDelete::add);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
            }
        });
        if (filesToDelete.isEmpty()) {
            return filesToDelete;
        }
        try {
            Tasks.foreach(currentManifestFiles).retry(3).stopOnFailure().throwFailureWhenFinished().executeWith(this.planExecutorService).onFailure((item, exc) -> LOG.warn("Failed to determine live files in manifest {}. Retrying", (Object)item.path(), (Object)exc)).run(manifest -> {
                if (filesToDelete.isEmpty()) {
                    return;
                }
                try (CloseableIterable<String> paths = ManifestFiles.readPaths(manifest, this.fileIO);){
                    paths.forEach(filesToDelete::remove);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Failed to list all reachable files", e);
            return Sets.newHashSet();
        }
        return filesToDelete;
    }
}

