/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class SerializableByteBufferMap
implements Map<Integer, ByteBuffer>,
Serializable {
    private final Map<Integer, ByteBuffer> wrapped;
    private volatile transient Map<Integer, ByteBuffer> immutableMap;

    static Map<Integer, ByteBuffer> wrap(Map<Integer, ByteBuffer> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof SerializableByteBufferMap) {
            return map;
        }
        return new SerializableByteBufferMap(map);
    }

    SerializableByteBufferMap() {
        this.wrapped = Maps.newLinkedHashMap();
    }

    private SerializableByteBufferMap(Map<Integer, ByteBuffer> wrapped) {
        this.wrapped = wrapped;
    }

    Object writeReplace() throws ObjectStreamException {
        Set<Map.Entry<Integer, ByteBuffer>> entries = this.wrapped.entrySet();
        int[] keys2 = new int[entries.size()];
        byte[][] values2 = new byte[keys2.length][];
        int keyIndex = 0;
        for (Map.Entry entry : entries) {
            keys2[keyIndex] = (Integer)entry.getKey();
            values2[keyIndex] = ByteBuffers.toByteArray((ByteBuffer)entry.getValue());
            ++keyIndex;
        }
        return new MapSerializationProxy(keys2, values2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ByteBuffer> immutableMap() {
        if (this.immutableMap == null) {
            SerializableByteBufferMap serializableByteBufferMap = this;
            synchronized (serializableByteBufferMap) {
                if (this.immutableMap == null) {
                    this.immutableMap = Collections.unmodifiableMap(this.wrapped);
                }
            }
        }
        return this.immutableMap;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public ByteBuffer get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public ByteBuffer put(Integer key, ByteBuffer value) {
        return this.wrapped.put(key, value);
    }

    @Override
    public ByteBuffer remove(Object key) {
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends ByteBuffer> m4) {
        this.wrapped.putAll(m4);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<Integer> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<ByteBuffer> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<Integer, ByteBuffer>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    private static class MapSerializationProxy
    implements Serializable {
        private int[] keys = null;
        private byte[][] values = null;

        MapSerializationProxy() {
        }

        MapSerializationProxy(int[] keys2, byte[][] values2) {
            this.keys = keys2;
            this.values = values2;
        }

        Object readResolve() throws ObjectStreamException {
            LinkedHashMap<Integer, ByteBuffer> map = Maps.newLinkedHashMap();
            for (int i = 0; i < this.keys.length; ++i) {
                map.put(this.keys[i], ByteBuffer.wrap(this.values[i]));
            }
            return SerializableByteBufferMap.wrap(map);
        }
    }
}

