/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.avro;

import com.dataiku.dss.shadelib.org.apache.iceberg.util.UUIDUtil;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;

public class UUIDConversion
extends Conversion<UUID> {
    public Class<UUID> getConvertedType() {
        return UUID.class;
    }

    public String getLogicalTypeName() {
        return LogicalTypes.uuid().getName();
    }

    public UUID fromFixed(GenericFixed value, Schema schema, LogicalType type) {
        return UUIDUtil.convert(value.bytes());
    }

    public GenericFixed toFixed(UUID value, Schema schema, LogicalType type) {
        return new GenericData.Fixed(schema, UUIDUtil.convert(value));
    }
}

