/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.Avro;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.DeleteLoader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.InternalRecordWrapper;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.avro.PlannedDataReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.orc.GenericOrcReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.GenericParquetReaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.Deletes;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteIndex;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteIndexUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RangeReadable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.orc.ORC;
import com.dataiku.dss.shadelib.org.apache.iceberg.orc.OrcRowReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.Parquet;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.io.ByteStreams;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.math.LongMath;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ContentFileUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDeleteLoader
implements DeleteLoader {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDeleteLoader.class);
    private static final Schema POS_DELETE_SCHEMA = DeleteSchemaUtil.pathPosSchema();
    private final Function<DeleteFile, InputFile> loadInputFile;
    private final ExecutorService workerPool;

    public BaseDeleteLoader(Function<DeleteFile, InputFile> loadInputFile) {
        this(loadInputFile, ThreadPools.getDeleteWorkerPool());
    }

    public BaseDeleteLoader(Function<DeleteFile, InputFile> loadInputFile, ExecutorService workerPool) {
        this.loadInputFile = loadInputFile;
        this.workerPool = workerPool;
    }

    protected boolean canCache(long size) {
        return false;
    }

    protected <V> V getOrLoad(String key, Supplier<V> valueSupplier, long valueSize) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support caching");
    }

    @Override
    public StructLikeSet loadEqualityDeletes(Iterable<DeleteFile> deleteFiles, Schema projection) {
        Iterable<Iterable> deletes = this.execute(deleteFiles, deleteFile -> this.getOrReadEqDeletes((DeleteFile)deleteFile, projection));
        StructLikeSet deleteSet = StructLikeSet.create(projection.asStruct());
        Iterables.addAll(deleteSet, Iterables.concat(deletes));
        return deleteSet;
    }

    private Iterable<StructLike> getOrReadEqDeletes(DeleteFile deleteFile, Schema projection) {
        long estimatedSize = this.estimateEqDeletesSize(deleteFile, projection);
        if (this.canCache(estimatedSize)) {
            String cacheKey = deleteFile.location();
            return this.getOrLoad(cacheKey, () -> this.readEqDeletes(deleteFile, projection), estimatedSize);
        }
        return this.readEqDeletes(deleteFile, projection);
    }

    private Iterable<StructLike> readEqDeletes(DeleteFile deleteFile, Schema projection) {
        CloseableIterable<Record> deletes = this.openDeletes(deleteFile, projection);
        CloseableIterable<Record> copiedDeletes = CloseableIterable.transform(deletes, Record::copy);
        CloseableIterable<StructLike> copiedDeletesAsStructs = this.toStructs(copiedDeletes, projection);
        return this.materialize(copiedDeletesAsStructs);
    }

    private CloseableIterable<StructLike> toStructs(CloseableIterable<Record> records, Schema schema) {
        InternalRecordWrapper wrapper = new InternalRecordWrapper(schema.asStruct());
        return CloseableIterable.transform(records, wrapper::copyFor);
    }

    private <T> Iterable<T> materialize(CloseableIterable<T> iterable) {
        ImmutableList<T> immutableList;
        block8: {
            CloseableIterable<T> closeableIterable = iterable;
            try {
                immutableList = ImmutableList.copyOf(closeableIterable);
                if (closeableIterable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeableIterable != null) {
                        try {
                            closeableIterable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close iterable", e);
                }
            }
            closeableIterable.close();
        }
        return immutableList;
    }

    @Override
    public PositionDeleteIndex loadPositionDeletes(Iterable<DeleteFile> deleteFiles, CharSequence filePath) {
        if (ContentFileUtil.containsSingleDV(deleteFiles)) {
            DeleteFile dv = Iterables.getOnlyElement(deleteFiles);
            this.validateDV(dv, filePath);
            return this.readDV(dv);
        }
        return this.getOrReadPosDeletes(deleteFiles, filePath);
    }

    private PositionDeleteIndex readDV(DeleteFile dv) {
        LOG.trace("Opening DV file {}", (Object)dv.location());
        InputFile inputFile = this.loadInputFile.apply(dv);
        long offset = dv.contentOffset();
        int length = dv.contentSizeInBytes().intValue();
        byte[] bytes = BaseDeleteLoader.readBytes(inputFile, offset, length);
        return PositionDeleteIndex.deserialize(bytes, dv);
    }

    private PositionDeleteIndex getOrReadPosDeletes(Iterable<DeleteFile> deleteFiles, CharSequence filePath) {
        Iterable<PositionDeleteIndex> deletes = this.execute(deleteFiles, deleteFile -> this.getOrReadPosDeletes((DeleteFile)deleteFile, filePath));
        return PositionDeleteIndexUtil.merge(deletes);
    }

    private PositionDeleteIndex getOrReadPosDeletes(DeleteFile deleteFile, CharSequence filePath) {
        long estimatedSize = this.estimatePosDeletesSize(deleteFile);
        if (this.canCache(estimatedSize)) {
            String cacheKey = deleteFile.location();
            CharSequenceMap indexes = this.getOrLoad(cacheKey, () -> this.readPosDeletes(deleteFile), estimatedSize);
            return indexes.getOrDefault(filePath, PositionDeleteIndex.empty());
        }
        return this.readPosDeletes(deleteFile, filePath);
    }

    private CharSequenceMap<PositionDeleteIndex> readPosDeletes(DeleteFile deleteFile) {
        CloseableIterable<Record> deletes = this.openDeletes(deleteFile, POS_DELETE_SCHEMA);
        return Deletes.toPositionIndexes(deletes, deleteFile);
    }

    private PositionDeleteIndex readPosDeletes(DeleteFile deleteFile, CharSequence filePath) {
        UnboundPredicate<CharSequence> filter = Expressions.equal(MetadataColumns.DELETE_FILE_PATH.name(), filePath);
        CloseableIterable<Record> deletes = this.openDeletes(deleteFile, POS_DELETE_SCHEMA, filter);
        return Deletes.toPositionIndex(filePath, deletes, deleteFile);
    }

    private CloseableIterable<Record> openDeletes(DeleteFile deleteFile, Schema projection) {
        return this.openDeletes(deleteFile, projection, null);
    }

    private CloseableIterable<Record> openDeletes(DeleteFile deleteFile, Schema projection, Expression filter) {
        FileFormat format = deleteFile.format();
        LOG.trace("Opening delete file {}", (Object)deleteFile.location());
        InputFile inputFile = this.loadInputFile.apply(deleteFile);
        switch (format) {
            case AVRO: {
                return Avro.read(inputFile).project(projection).reuseContainers().createResolvingReader(PlannedDataReader::create).build();
            }
            case PARQUET: {
                return Parquet.read(inputFile).project(projection).filter(filter).reuseContainers().createReaderFunc(this.newParquetReaderFunc(projection)).build();
            }
            case ORC: {
                return ORC.read((InputFile)inputFile).project(projection).filter(filter).createReaderFunc(this.newOrcReaderFunc(projection)).build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported file format: %s", format.name(), inputFile.location()));
    }

    private Function<MessageType, ParquetValueReader<?>> newParquetReaderFunc(Schema projection) {
        return fileSchema -> GenericParquetReaders.buildReader(projection, fileSchema);
    }

    private Function<TypeDescription, OrcRowReader<?>> newOrcReaderFunc(Schema projection) {
        return fileSchema -> GenericOrcReader.buildReader((Schema)projection, (TypeDescription)fileSchema);
    }

    private <I, O> Iterable<O> execute(Iterable<I> objects, Function<I, O> func) {
        ConcurrentLinkedQueue output = new ConcurrentLinkedQueue();
        Tasks.foreach(objects).executeWith(this.workerPool).stopOnFailure().onFailure((object, exc) -> LOG.error("Failed to process {}", object, (Object)exc)).run(object -> output.add(func.apply(object)));
        return output;
    }

    private long estimatePosDeletesSize(DeleteFile deleteFile) {
        return deleteFile.recordCount();
    }

    private long estimateEqDeletesSize(DeleteFile deleteFile, Schema projection) {
        try {
            long recordCount = deleteFile.recordCount();
            int recordSize = this.estimateRecordSize(projection);
            return LongMath.checkedMultiply(recordCount, recordSize);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    private int estimateRecordSize(Schema schema) {
        return schema.columns().stream().mapToInt(TypeUtil::estimateSize).sum();
    }

    private void validateDV(DeleteFile dv, CharSequence filePath) {
        Preconditions.checkArgument(dv.contentOffset() != null, "Invalid DV, offset cannot be null: %s", (Object)ContentFileUtil.dvDesc(dv));
        Preconditions.checkArgument(dv.contentSizeInBytes() != null, "Invalid DV, length is null: %s", (Object)ContentFileUtil.dvDesc(dv));
        Preconditions.checkArgument(dv.contentSizeInBytes() <= Integer.MAX_VALUE, "Can't read DV larger than 2GB: %s", (Object)dv.contentSizeInBytes());
        Preconditions.checkArgument(filePath.toString().equals(dv.referencedDataFile()), "DV is expected to reference %s, not %s", (Object)filePath, (Object)dv.referencedDataFile());
    }

    private static byte[] readBytes(InputFile inputFile, long offset, int length) {
        byte[] byArray;
        block10: {
            SeekableInputStream stream = inputFile.newStream();
            try {
                byte[] bytes = new byte[length];
                if (stream instanceof RangeReadable) {
                    RangeReadable rangeReadable = (RangeReadable)((Object)stream);
                    rangeReadable.readFully(offset, bytes);
                } else {
                    stream.seek(offset);
                    ByteStreams.readFully(stream, bytes);
                }
                byArray = bytes;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

