/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.deletes;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppender;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EqualityDeleteWriter<T>
implements FileWriter<T, DeleteWriteResult> {
    private final FileAppender<T> appender;
    private final FileFormat format;
    private final String location;
    private final PartitionSpec spec;
    private final StructLike partition;
    private final ByteBuffer keyMetadata;
    private final int[] equalityFieldIds;
    private final SortOrder sortOrder;
    private DeleteFile deleteFile = null;

    public EqualityDeleteWriter(FileAppender<T> appender, FileFormat format, String location, PartitionSpec spec, StructLike partition, EncryptionKeyMetadata keyMetadata, SortOrder sortOrder, int ... equalityFieldIds) {
        this.appender = appender;
        this.format = format;
        this.location = location;
        this.spec = spec;
        this.partition = partition;
        this.keyMetadata = keyMetadata != null ? keyMetadata.buffer() : null;
        this.sortOrder = sortOrder;
        this.equalityFieldIds = equalityFieldIds;
    }

    @Override
    public void write(T row) {
        this.appender.add(row);
    }

    @Override
    public long length() {
        return this.appender.length();
    }

    @Override
    public void close() throws IOException {
        if (this.deleteFile == null) {
            this.appender.close();
            this.deleteFile = FileMetadata.deleteFileBuilder(this.spec).ofEqualityDeletes(this.equalityFieldIds).withFormat(this.format).withPath(this.location).withPartition(this.partition).withEncryptionKeyMetadata(this.keyMetadata).withFileSizeInBytes(this.appender.length()).withMetrics(this.appender.metrics()).withSplitOffsets(this.appender.splitOffsets()).withSortOrder(this.sortOrder).build();
        }
    }

    public DeleteFile toDeleteFile() {
        Preconditions.checkState(this.deleteFile != null, "Cannot create delete file from unclosed writer");
        return this.deleteFile;
    }

    @Override
    public DeleteWriteResult result() {
        return new DeleteWriteResult(this.toDeleteFile());
    }
}

