/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;

public class Or
implements Expression {
    private final Expression left;
    private final Expression right;

    Or(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public Expression.Operation op() {
        return Expression.Operation.OR;
    }

    @Override
    public boolean isEquivalentTo(Expression expr) {
        if (expr.op() == Expression.Operation.OR) {
            Or other = (Or)expr;
            return this.left.isEquivalentTo(other.left()) && this.right.isEquivalentTo(other.right()) || this.left.isEquivalentTo(other.right()) && this.right.isEquivalentTo(other.left());
        }
        return false;
    }

    @Override
    public Expression negate() {
        return Expressions.and(this.left.negate(), this.right.negate());
    }

    public String toString() {
        return String.format("(%s or %s)", this.left, this.right);
    }
}

