/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PartitioningWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PositionDeltaWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.WriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import java.io.IOException;

public class BasePositionDeltaWriter<T>
implements PositionDeltaWriter<T> {
    private final PartitioningWriter<T, DataWriteResult> insertWriter;
    private final PartitioningWriter<T, DataWriteResult> updateWriter;
    private final PartitioningWriter<PositionDelete<T>, DeleteWriteResult> deleteWriter;
    private final PositionDelete<T> positionDelete;
    private boolean closed;

    public BasePositionDeltaWriter(PartitioningWriter<T, DataWriteResult> dataWriter, PartitioningWriter<PositionDelete<T>, DeleteWriteResult> deleteWriter) {
        this(dataWriter, dataWriter, deleteWriter);
    }

    public BasePositionDeltaWriter(PartitioningWriter<T, DataWriteResult> insertWriter, PartitioningWriter<T, DataWriteResult> updateWriter, PartitioningWriter<PositionDelete<T>, DeleteWriteResult> deleteWriter) {
        Preconditions.checkArgument(insertWriter != null, "Insert writer cannot be null");
        Preconditions.checkArgument(updateWriter != null, "Update writer cannot be null");
        Preconditions.checkArgument(deleteWriter != null, "Delete writer cannot be null");
        this.insertWriter = insertWriter;
        this.updateWriter = updateWriter;
        this.deleteWriter = deleteWriter;
        this.positionDelete = PositionDelete.create();
    }

    @Override
    public void insert(T row, PartitionSpec spec, StructLike partition) {
        this.insertWriter.write(row, spec, partition);
    }

    @Override
    public void update(T row, PartitionSpec spec, StructLike partition) {
        this.updateWriter.write(row, spec, partition);
    }

    @Override
    public void delete(CharSequence path, long pos, T row, PartitionSpec spec, StructLike partition) {
        this.positionDelete.set(path, pos, row);
        this.deleteWriter.write(this.positionDelete, spec, partition);
    }

    @Override
    public WriteResult result() {
        Preconditions.checkState(this.closed, "Cannot get result from unclosed writer");
        DeleteWriteResult deleteWriteResult = this.deleteWriter.result();
        return WriteResult.builder().addDataFiles(this.dataFiles()).addDeleteFiles(deleteWriteResult.deleteFiles()).addReferencedDataFiles(deleteWriteResult.referencedDataFiles()).addRewrittenDeleteFiles(deleteWriteResult.rewrittenDeleteFiles()).build();
    }

    private Iterable<DataFile> dataFiles() {
        if (this.insertWriter == this.updateWriter) {
            DataWriteResult result = this.insertWriter.result();
            return result.dataFiles();
        }
        DataWriteResult insertWriteResult = this.insertWriter.result();
        DataWriteResult updateWriteResult = this.updateWriter.result();
        return Iterables.concat(insertWriteResult.dataFiles(), updateWriteResult.dataFiles());
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.insertWriter.close();
            this.updateWriter.close();
            this.deleteWriter.close();
            this.closed = true;
        }
    }
}

