/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppender;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DataWriter<T>
implements FileWriter<T, DataWriteResult> {
    private final FileAppender<T> appender;
    private final FileFormat format;
    private final String location;
    private final PartitionSpec spec;
    private final StructLike partition;
    private final ByteBuffer keyMetadata;
    private final SortOrder sortOrder;
    private DataFile dataFile = null;

    public DataWriter(FileAppender<T> appender, FileFormat format, String location, PartitionSpec spec, StructLike partition, EncryptionKeyMetadata keyMetadata) {
        this(appender, format, location, spec, partition, keyMetadata, null);
    }

    public DataWriter(FileAppender<T> appender, FileFormat format, String location, PartitionSpec spec, StructLike partition, EncryptionKeyMetadata keyMetadata, SortOrder sortOrder) {
        this.appender = appender;
        this.format = format;
        this.location = location;
        this.spec = spec;
        this.partition = partition;
        this.keyMetadata = keyMetadata != null ? keyMetadata.buffer() : null;
        this.sortOrder = sortOrder;
    }

    @Override
    public void write(T row) {
        this.appender.add(row);
    }

    @Override
    public long length() {
        return this.appender.length();
    }

    @Override
    public void close() throws IOException {
        if (this.dataFile == null) {
            this.appender.close();
            this.dataFile = DataFiles.builder(this.spec).withFormat(this.format).withPath(this.location).withPartition(this.partition).withEncryptionKeyMetadata(this.keyMetadata).withFileSizeInBytes(this.appender.length()).withMetrics(this.appender.metrics()).withSplitOffsets(this.appender.splitOffsets()).withSortOrder(this.sortOrder).build();
        }
    }

    public DataFile toDataFile() {
        Preconditions.checkState(this.dataFile != null, "Cannot create data file from unclosed writer");
        return this.dataFile;
    }

    @Override
    public DataWriteResult result() {
        return new DataWriteResult(this.toDataFile());
    }
}

