/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.ByteBufferInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

class SingleBufferInputStream
extends ByteBufferInputStream {
    private final ByteBuffer original;
    private final long startPosition;
    private final int length;
    private ByteBuffer buffer;
    private int mark;

    SingleBufferInputStream(ByteBuffer buffer) {
        this.original = buffer;
        this.startPosition = buffer.position();
        this.length = this.original.remaining();
        this.initFromBuffer();
    }

    private void initFromBuffer() {
        this.mark = -1;
        this.buffer = this.original.duplicate();
    }

    @Override
    public long getPos() {
        return (long)this.buffer.position() - this.startPosition;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return -1;
        }
        int bytesToRead = Math.min(this.buffer.remaining(), len);
        this.buffer.get(bytes, off, bytesToRead);
        return bytesToRead;
    }

    @Override
    public void seek(long newPosition) throws IOException {
        if (newPosition > (long)this.length) {
            throw new EOFException(String.format("Cannot seek to position after end of file: %s", newPosition));
        }
        if (this.getPos() > newPosition) {
            this.initFromBuffer();
        }
        long bytesToSkip = newPosition - this.getPos();
        this.skipFully(bytesToSkip);
    }

    @Override
    public long skip(long len) {
        if (len == 0L) {
            return 0L;
        }
        if (this.buffer.remaining() <= 0) {
            return -1L;
        }
        int bytesToSkip = (int)Math.min((long)this.buffer.remaining(), len);
        this.buffer.position(this.buffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    @Override
    public int read(ByteBuffer out) {
        ByteBuffer copyBuffer;
        int bytesToCopy;
        if (this.buffer.remaining() <= out.remaining()) {
            bytesToCopy = this.buffer.remaining();
            copyBuffer = this.buffer;
        } else {
            bytesToCopy = out.remaining();
            copyBuffer = this.buffer.duplicate();
            copyBuffer.limit(this.buffer.position() + bytesToCopy);
            this.buffer.position(this.buffer.position() + bytesToCopy);
        }
        out.put(copyBuffer);
        out.flip();
        return bytesToCopy;
    }

    @Override
    public ByteBuffer slice(int len) throws EOFException {
        if (this.buffer.remaining() < len) {
            throw new EOFException();
        }
        ByteBuffer copy = this.buffer.duplicate();
        copy.limit(copy.position() + len);
        this.buffer.position(this.buffer.position() + len);
        return copy;
    }

    @Override
    public List<ByteBuffer> sliceBuffers(long len) throws EOFException {
        if (len == 0L) {
            return Collections.emptyList();
        }
        if (len > (long)this.buffer.remaining()) {
            throw new EOFException();
        }
        return Collections.singletonList(this.slice((int)len));
    }

    @Override
    public List<ByteBuffer> remainingBuffers() {
        if (this.buffer.remaining() <= 0) {
            return Collections.emptyList();
        }
        ByteBuffer remaining = this.buffer.duplicate();
        this.buffer.position(this.buffer.limit());
        return Collections.singletonList(remaining);
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("No mark defined");
        }
        this.buffer.position(this.mark);
        this.mark = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }
}

