/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DelegatingInputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DelegatingOutputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PositionOutputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HadoopStreams;
import com.dataiku.dss.shadelib.org.apache.parquet.io.DelegatingPositionOutputStream;
import com.dataiku.dss.shadelib.org.apache.parquet.io.DelegatingSeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.parquet.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.parquet.io.OutputFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

class ParquetIO {
    private ParquetIO() {
    }

    static InputFile file(com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile file) {
        if (file instanceof HadoopInputFile) {
            HadoopInputFile hfile = (HadoopInputFile)file;
            try {
                return com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HadoopInputFile.fromStatus(hfile.getStat(), hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet input file for %s", file.location());
            }
        }
        return new ParquetInputFile(file);
    }

    static OutputFile file(com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile file) {
        if (file instanceof HadoopOutputFile) {
            HadoopOutputFile hfile = (HadoopOutputFile)file;
            try {
                return com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HadoopOutputFile.fromPath(hfile.getPath(), hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", file.location());
            }
        }
        return new ParquetOutputFile(file);
    }

    static OutputFile file(com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile file, Configuration conf) {
        if (file instanceof HadoopOutputFile) {
            HadoopOutputFile hfile = (HadoopOutputFile)file;
            try {
                return com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HadoopOutputFile.fromPath(hfile.getPath(), conf);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", file.location());
            }
        }
        return new ParquetOutputFile(file);
    }

    static com.dataiku.dss.shadelib.org.apache.parquet.io.SeekableInputStream stream(SeekableInputStream stream) {
        InputStream wrapped;
        if (stream instanceof DelegatingInputStream && (wrapped = ((DelegatingInputStream)((Object)stream)).getDelegate()) instanceof FSDataInputStream) {
            return HadoopStreams.wrap((FSDataInputStream)wrapped);
        }
        return new ParquetInputStreamAdapter(stream);
    }

    static com.dataiku.dss.shadelib.org.apache.parquet.io.PositionOutputStream stream(PositionOutputStream stream) {
        OutputStream wrapped;
        if (stream instanceof DelegatingOutputStream && (wrapped = ((DelegatingOutputStream)((Object)stream)).getDelegate()) instanceof FSDataOutputStream) {
            return HadoopStreams.wrap((FSDataOutputStream)wrapped);
        }
        return new ParquetOutputStreamAdapter(stream);
    }

    private static class ParquetInputFile
    implements InputFile {
        private final com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile file;

        private ParquetInputFile(com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile file) {
            this.file = file;
        }

        @Override
        public long getLength() throws IOException {
            return this.file.getLength();
        }

        @Override
        public com.dataiku.dss.shadelib.org.apache.parquet.io.SeekableInputStream newStream() throws IOException {
            return ParquetIO.stream(this.file.newStream());
        }
    }

    private static class ParquetOutputFile
    implements OutputFile {
        private final com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile file;

        private ParquetOutputFile(com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile file) {
            this.file = file;
        }

        @Override
        public com.dataiku.dss.shadelib.org.apache.parquet.io.PositionOutputStream create(long ignored) throws IOException {
            return ParquetIO.stream(this.file.create());
        }

        @Override
        public com.dataiku.dss.shadelib.org.apache.parquet.io.PositionOutputStream createOrOverwrite(long ignored) throws IOException {
            return ParquetIO.stream(this.file.createOrOverwrite());
        }

        @Override
        public boolean supportsBlockSize() {
            return false;
        }

        @Override
        public long defaultBlockSize() {
            return 0L;
        }
    }

    private static class ParquetInputStreamAdapter
    extends DelegatingSeekableInputStream {
        private final SeekableInputStream delegate;

        private ParquetInputStreamAdapter(SeekableInputStream delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }
    }

    private static class ParquetOutputStreamAdapter
    extends DelegatingPositionOutputStream {
        private final PositionOutputStream delegate;

        private ParquetOutputStreamAdapter(PositionOutputStream delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }
    }
}

