/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.EnvironmentContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transaction;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transactions;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.BaseViewSessionCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SessionCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableCommit;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.AlreadyExistsException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchNamespaceException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchTableException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchViewException;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.Configurable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIOTracker;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.StorageCredential;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporters;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.Endpoint;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ErrorHandlers;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTMetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTViewOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ResourcePaths;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthManagers;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.Credential;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CommitTransactionRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.RenameTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ConfigResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.GetNamespaceResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ListNamespacesResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ListTablesResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadTableResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.EnvironmentUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.BaseView;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableViewVersion;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.View;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewBuilder;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTSessionCatalog
extends BaseViewSessionCatalog
implements Configurable<Object>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RESTSessionCatalog.class);
    private static final String DEFAULT_FILE_IO_IMPL = "com.dataiku.dss.shadelib.org.apache.iceberg.io.ResolvingFileIO";
    private static final String REST_METRICS_REPORTING_ENABLED = "rest-metrics-reporting-enabled";
    private static final String REST_SNAPSHOT_LOADING_MODE = "snapshot-loading-mode";
    static final String VIEW_ENDPOINTS_SUPPORTED = "view-endpoints-supported";
    public static final String REST_PAGE_SIZE = "rest-page-size";
    private static final Set<Endpoint> DEFAULT_ENDPOINTS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Endpoint.V1_LIST_NAMESPACES)).add(Endpoint.V1_LOAD_NAMESPACE)).add(Endpoint.V1_CREATE_NAMESPACE)).add(Endpoint.V1_UPDATE_NAMESPACE)).add(Endpoint.V1_DELETE_NAMESPACE)).add(Endpoint.V1_LIST_TABLES)).add(Endpoint.V1_LOAD_TABLE)).add(Endpoint.V1_CREATE_TABLE)).add(Endpoint.V1_UPDATE_TABLE)).add(Endpoint.V1_DELETE_TABLE)).add(Endpoint.V1_RENAME_TABLE)).add(Endpoint.V1_REGISTER_TABLE)).add(Endpoint.V1_REPORT_METRICS)).add(Endpoint.V1_COMMIT_TRANSACTION)).build();
    private static final Set<Endpoint> VIEW_ENDPOINTS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Endpoint.V1_LIST_VIEWS)).add(Endpoint.V1_LOAD_VIEW)).add(Endpoint.V1_CREATE_VIEW)).add(Endpoint.V1_UPDATE_VIEW)).add(Endpoint.V1_DELETE_VIEW)).add(Endpoint.V1_RENAME_VIEW)).build();
    private final Function<Map<String, String>, RESTClient> clientBuilder;
    private final BiFunction<SessionCatalog.SessionContext, Map<String, String>, FileIO> ioBuilder;
    private FileIOTracker fileIOTracker = null;
    private AuthSession catalogAuth = null;
    private AuthManager authManager;
    private RESTClient client = null;
    private ResourcePaths paths = null;
    private SnapshotMode snapshotMode = null;
    private Object conf = null;
    private FileIO io = null;
    private MetricsReporter reporter = null;
    private boolean reportingViaRestEnabled;
    private Integer pageSize = null;
    private CloseableGroup closeables = null;
    private Set<Endpoint> endpoints;

    public RESTSessionCatalog() {
        this(config -> HTTPClient.builder(config).uri((String)config.get("uri")).withHeaders(RESTUtil.configHeaders(config)).build(), null);
    }

    public RESTSessionCatalog(Function<Map<String, String>, RESTClient> clientBuilder, BiFunction<SessionCatalog.SessionContext, Map<String, String>, FileIO> ioBuilder) {
        Preconditions.checkNotNull(clientBuilder, "Invalid client builder: null");
        this.clientBuilder = clientBuilder;
        this.ioBuilder = ioBuilder;
    }

    @Override
    public void initialize(String name, Map<String, String> unresolved) {
        ConfigResponse config;
        Preconditions.checkArgument(unresolved != null, "Invalid configuration: null");
        Map<String, String> props = EnvironmentUtil.resolveAll(unresolved);
        this.closeables = new CloseableGroup();
        this.authManager = AuthManagers.loadAuthManager(name, props);
        this.closeables.addCloseable(this.authManager);
        try (RESTClient initClient = this.clientBuilder.apply(props);
             AuthSession initSession = this.authManager.initSession(initClient, props);){
            config = RESTSessionCatalog.fetchConfig(initClient.withAuthSession(initSession), initSession, props);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close HTTP client", e);
        }
        Map<String, String> mergedProps = config.merge(props);
        this.endpoints = config.endpoints().isEmpty() ? (PropertyUtil.propertyAsBoolean(mergedProps, VIEW_ENDPOINTS_SUPPORTED, false) ? ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DEFAULT_ENDPOINTS)).addAll(VIEW_ENDPOINTS)).build() : DEFAULT_ENDPOINTS) : ImmutableSet.copyOf(config.endpoints());
        this.client = this.clientBuilder.apply(mergedProps);
        this.closeables.addCloseable(this.client);
        this.paths = ResourcePaths.forCatalogProperties(mergedProps);
        this.catalogAuth = this.authManager.catalogSession(this.client, mergedProps);
        this.closeables.addCloseable(this.catalogAuth);
        this.pageSize = PropertyUtil.propertyAsNullableInt(mergedProps, REST_PAGE_SIZE);
        if (this.pageSize != null) {
            Preconditions.checkArgument(this.pageSize > 0, "Invalid value for %s, must be a positive integer", (Object)REST_PAGE_SIZE);
        }
        this.io = this.newFileIO(SessionCatalog.SessionContext.createEmpty(), mergedProps);
        this.fileIOTracker = new FileIOTracker();
        this.closeables.addCloseable(this.io);
        this.closeables.addCloseable(this.fileIOTracker);
        this.closeables.setSuppressCloseFailure(true);
        this.snapshotMode = SnapshotMode.valueOf(PropertyUtil.propertyAsString(mergedProps, REST_SNAPSHOT_LOADING_MODE, SnapshotMode.ALL.name()).toUpperCase(Locale.US));
        this.reporter = CatalogUtil.loadMetricsReporter(mergedProps);
        this.reportingViaRestEnabled = PropertyUtil.propertyAsBoolean(mergedProps, REST_METRICS_REPORTING_ENABLED, true);
        super.initialize(name, mergedProps);
    }

    @Override
    public void setConf(Object newConf) {
        this.conf = newConf;
    }

    @Override
    public List<TableIdentifier> listTables(SessionCatalog.SessionContext context, Namespace ns) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_TABLES)) {
            return ImmutableList.of();
        }
        this.checkNamespaceIsValid(ns);
        HashMap<String, String> queryParams = Maps.newHashMap();
        ImmutableList.Builder tables = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            ListTablesResponse response = this.client.withAuthSession(contextualSession).get(this.paths.tables(ns), queryParams, ListTablesResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            tables.addAll(response.identifiers());
        } while (pageToken != null);
        return tables.build();
    }

    @Override
    public boolean dropTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_TABLE);
        this.checkIdentifierIsValid(identifier);
        try {
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            this.client.withAuthSession(contextualSession).delete(this.paths.table(identifier), null, Map.of(), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public boolean purgeTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_TABLE);
        this.checkIdentifierIsValid(identifier);
        try {
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            this.client.withAuthSession(contextualSession).delete(this.paths.table(identifier), ImmutableMap.of("purgeRequested", "true"), null, Map.of(), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public void renameTable(SessionCatalog.SessionContext context, TableIdentifier from, TableIdentifier to) {
        Endpoint.check(this.endpoints, Endpoint.V1_RENAME_TABLE);
        this.checkIdentifierIsValid(from);
        this.checkIdentifierIsValid(to);
        RenameTableRequest request = RenameTableRequest.builder().withSource(from).withDestination(to).build();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        this.client.withAuthSession(contextualSession).post(this.paths.rename(), (RESTRequest)request, null, Map.of(), ErrorHandlers.tableErrorHandler());
    }

    @Override
    public boolean tableExists(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        try {
            this.checkIdentifierIsValid(identifier);
            if (this.endpoints.contains(Endpoint.V1_TABLE_EXISTS)) {
                AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
                this.client.withAuthSession(contextualSession).head(this.paths.table(identifier), Map.of(), ErrorHandlers.tableErrorHandler());
                return true;
            }
            return super.tableExists(context, identifier);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    private LoadTableResponse loadInternal(SessionCatalog.SessionContext context, TableIdentifier identifier, SnapshotMode mode) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_TABLE);
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        return this.client.withAuthSession(contextualSession).get(this.paths.table(identifier), mode.params(), LoadTableResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
    }

    @Override
    public Table loadTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        MetadataTableType metadataType;
        TableIdentifier loadedIdent;
        LoadTableResponse response;
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_TABLE, () -> new NoSuchTableException("Unable to load table %s.%s: Server does not support endpoint %s", this.name(), identifier, Endpoint.V1_LOAD_TABLE));
        this.checkIdentifierIsValid(identifier);
        try {
            response = this.loadInternal(context, identifier, this.snapshotMode);
            loadedIdent = identifier;
            metadataType = null;
        }
        catch (NoSuchTableException original) {
            metadataType = MetadataTableType.from(identifier.name());
            if (metadataType != null) {
                TableIdentifier baseIdent = TableIdentifier.of(identifier.namespace().levels());
                try {
                    response = this.loadInternal(context, baseIdent, this.snapshotMode);
                    loadedIdent = baseIdent;
                }
                catch (NoSuchTableException ignored) {
                    throw original;
                }
            }
            throw original;
        }
        TableIdentifier finalIdentifier = loadedIdent;
        Map<String, String> tableConf = response.config();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        AuthSession tableSession = this.authManager.tableSession(finalIdentifier, tableConf, contextualSession);
        TableMetadata tableMetadata = this.snapshotMode == SnapshotMode.REFS ? TableMetadata.buildFrom(response.tableMetadata()).withMetadataLocation(response.metadataLocation()).setPreviousFileLocation(null).setSnapshotsSupplier(() -> this.loadInternal(context, finalIdentifier, SnapshotMode.ALL).tableMetadata().snapshots()).discardChanges().build() : response.tableMetadata();
        RESTClient tableClient = this.client.withAuthSession(tableSession);
        RESTTableOperations ops = new RESTTableOperations(tableClient, this.paths.table(finalIdentifier), Map::of, this.tableFileIO(context, tableConf, response.credentials()), tableMetadata, this.endpoints);
        this.trackFileIO(ops);
        BaseTable table = new BaseTable(ops, this.fullTableName(finalIdentifier), this.metricsReporter(this.paths.metrics(finalIdentifier), tableClient));
        if (metadataType != null) {
            return MetadataTableUtils.createMetadataTableInstance(table, metadataType);
        }
        return table;
    }

    private void trackFileIO(RESTTableOperations ops) {
        if (this.io != ops.io()) {
            this.fileIOTracker.track(ops);
        }
    }

    private MetricsReporter metricsReporter(String metricsEndpoint, RESTClient restClient) {
        if (this.reportingViaRestEnabled && this.endpoints.contains(Endpoint.V1_REPORT_METRICS)) {
            RESTMetricsReporter restMetricsReporter = new RESTMetricsReporter(restClient, metricsEndpoint, Map::of);
            return MetricsReporters.combine(this.reporter, restMetricsReporter);
        }
        return this.reporter;
    }

    @Override
    public Catalog.TableBuilder buildTable(SessionCatalog.SessionContext context, TableIdentifier identifier, Schema schema) {
        return new Builder(identifier, schema, context);
    }

    @Override
    public void invalidateTable(SessionCatalog.SessionContext context, TableIdentifier ident) {
    }

    @Override
    public Table registerTable(SessionCatalog.SessionContext context, TableIdentifier ident, String metadataFileLocation) {
        Endpoint.check(this.endpoints, Endpoint.V1_REGISTER_TABLE);
        this.checkIdentifierIsValid(ident);
        Preconditions.checkArgument(metadataFileLocation != null && !metadataFileLocation.isEmpty(), "Invalid metadata file location: %s", (Object)metadataFileLocation);
        ImmutableRegisterTableRequest request = ImmutableRegisterTableRequest.builder().name(ident.name()).metadataLocation(metadataFileLocation).build();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        LoadTableResponse response = this.client.withAuthSession(contextualSession).post(this.paths.register(ident.namespace()), (RESTRequest)request, LoadTableResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
        Map<String, String> tableConf = response.config();
        AuthSession tableSession = this.authManager.tableSession(ident, tableConf, contextualSession);
        RESTClient tableClient = this.client.withAuthSession(tableSession);
        RESTTableOperations ops = new RESTTableOperations(tableClient, this.paths.table(ident), Map::of, this.tableFileIO(context, tableConf, response.credentials()), response.tableMetadata(), this.endpoints);
        this.trackFileIO(ops);
        return new BaseTable(ops, this.fullTableName(ident), this.metricsReporter(this.paths.metrics(ident), tableClient));
    }

    @Override
    public void createNamespace(SessionCatalog.SessionContext context, Namespace namespace, Map<String, String> metadata) {
        Endpoint.check(this.endpoints, Endpoint.V1_CREATE_NAMESPACE);
        CreateNamespaceRequest request = CreateNamespaceRequest.builder().withNamespace(namespace).setProperties(metadata).build();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        this.client.withAuthSession(contextualSession).post(this.paths.namespaces(), (RESTRequest)request, CreateNamespaceResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
    }

    @Override
    public List<Namespace> listNamespaces(SessionCatalog.SessionContext context, Namespace namespace) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_NAMESPACES)) {
            return ImmutableList.of();
        }
        HashMap<String, String> queryParams = Maps.newHashMap();
        if (!namespace.isEmpty()) {
            queryParams.put("parent", RESTUtil.NAMESPACE_JOINER.join(namespace.levels()));
        }
        ImmutableList.Builder namespaces = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            ListNamespacesResponse response = this.client.withAuthSession(contextualSession).get(this.paths.namespaces(), queryParams, ListNamespacesResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            namespaces.addAll(response.namespaces());
        } while (pageToken != null);
        return namespaces.build();
    }

    @Override
    public boolean namespaceExists(SessionCatalog.SessionContext context, Namespace namespace) {
        try {
            this.checkNamespaceIsValid(namespace);
            if (this.endpoints.contains(Endpoint.V1_NAMESPACE_EXISTS)) {
                AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
                this.client.withAuthSession(contextualSession).head(this.paths.namespace(namespace), Map.of(), ErrorHandlers.namespaceErrorHandler());
                return true;
            }
            return super.namespaceExists(context, namespace);
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        GetNamespaceResponse response = this.client.withAuthSession(contextualSession).get(this.paths.namespace(ns), GetNamespaceResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
        return response.properties();
    }

    @Override
    public boolean dropNamespace(SessionCatalog.SessionContext context, Namespace ns) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        try {
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            this.client.withAuthSession(contextualSession).delete(this.paths.namespace(ns), null, Map.of(), ErrorHandlers.dropNamespaceErrorHandler());
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    @Override
    public boolean updateNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns, Map<String, String> updates, Set<String> removals) {
        Endpoint.check(this.endpoints, Endpoint.V1_UPDATE_NAMESPACE);
        this.checkNamespaceIsValid(ns);
        UpdateNamespacePropertiesRequest request = UpdateNamespacePropertiesRequest.builder().updateAll(updates).removeAll(removals).build();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        UpdateNamespacePropertiesResponse response = this.client.withAuthSession(contextualSession).post(this.paths.namespaceProperties(ns), (RESTRequest)request, UpdateNamespacePropertiesResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
        return !response.updated().isEmpty();
    }

    @Override
    public void close() throws IOException {
        if (this.closeables != null) {
            this.closeables.close();
        }
    }

    private static List<MetadataUpdate> createChanges(TableMetadata meta) {
        Map<String, String> properties;
        ImmutableList.Builder changes = ImmutableList.builder();
        changes.add(new MetadataUpdate.AssignUUID(meta.uuid()));
        changes.add(new MetadataUpdate.UpgradeFormatVersion(meta.formatVersion()));
        Schema schema = meta.schema();
        changes.add(new MetadataUpdate.AddSchema(schema));
        changes.add(new MetadataUpdate.SetCurrentSchema(-1));
        PartitionSpec spec = meta.spec();
        if (spec != null && spec.isPartitioned()) {
            changes.add(new MetadataUpdate.AddPartitionSpec(spec));
        } else {
            changes.add(new MetadataUpdate.AddPartitionSpec(PartitionSpec.unpartitioned()));
        }
        changes.add(new MetadataUpdate.SetDefaultPartitionSpec(-1));
        SortOrder order = meta.sortOrder();
        if (order != null && order.isSorted()) {
            changes.add(new MetadataUpdate.AddSortOrder(order));
        } else {
            changes.add(new MetadataUpdate.AddSortOrder(SortOrder.unsorted()));
        }
        changes.add(new MetadataUpdate.SetDefaultSortOrder(-1));
        String location = meta.location();
        if (location != null) {
            changes.add(new MetadataUpdate.SetLocation(location));
        }
        if ((properties = meta.properties()) != null && !properties.isEmpty()) {
            changes.add(new MetadataUpdate.SetProperties(properties));
        }
        return changes.build();
    }

    private String fullTableName(TableIdentifier ident) {
        return String.format("%s.%s", this.name(), ident);
    }

    private FileIO newFileIO(SessionCatalog.SessionContext context, Map<String, String> properties) {
        return this.newFileIO(context, properties, ImmutableList.of());
    }

    private FileIO newFileIO(SessionCatalog.SessionContext context, Map<String, String> properties, List<Credential> storageCredentials) {
        if (null != this.ioBuilder) {
            return this.ioBuilder.apply(context, properties);
        }
        String ioImpl = properties.getOrDefault("io-impl", DEFAULT_FILE_IO_IMPL);
        return CatalogUtil.loadFileIO(ioImpl, properties, this.conf, storageCredentials.stream().map(c -> StorageCredential.create(c.prefix(), c.config())).collect(Collectors.toList()));
    }

    private FileIO tableFileIO(SessionCatalog.SessionContext context, Map<String, String> config, List<Credential> storageCredentials) {
        if (config.isEmpty() && this.ioBuilder == null && storageCredentials.isEmpty()) {
            return this.io;
        }
        Map<String, String> fullConf = RESTUtil.merge(this.properties(), config);
        return this.newFileIO(context, fullConf, storageCredentials);
    }

    private static ConfigResponse fetchConfig(RESTClient client, AuthSession initialAuth, Map<String, String> properties) {
        ImmutableMap.Builder<String, String> queryParams = ImmutableMap.builder();
        if (properties.containsKey("warehouse")) {
            queryParams.put("warehouse", properties.get("warehouse"));
        }
        ConfigResponse configResponse = client.withAuthSession(initialAuth).get(ResourcePaths.config(), queryParams.build(), ConfigResponse.class, RESTUtil.configHeaders(properties), ErrorHandlers.defaultErrorHandler());
        configResponse.validate();
        return configResponse;
    }

    private void checkIdentifierIsValid(TableIdentifier tableIdentifier) {
        if (tableIdentifier.namespace().isEmpty()) {
            throw new NoSuchTableException("Invalid table identifier: %s", tableIdentifier);
        }
    }

    private void checkViewIdentifierIsValid(TableIdentifier identifier) {
        if (identifier.namespace().isEmpty()) {
            throw new NoSuchViewException("Invalid view identifier: %s", identifier);
        }
    }

    private void checkNamespaceIsValid(Namespace namespace) {
        if (namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Invalid namespace: %s", namespace);
        }
    }

    public void commitTransaction(SessionCatalog.SessionContext context, List<TableCommit> commits) {
        Endpoint.check(this.endpoints, Endpoint.V1_COMMIT_TRANSACTION);
        ArrayList<UpdateTableRequest> tableChanges = Lists.newArrayListWithCapacity(commits.size());
        for (TableCommit commit : commits) {
            tableChanges.add(UpdateTableRequest.create(commit.identifier(), commit.requirements(), commit.updates()));
        }
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        this.client.withAuthSession(contextualSession).post(this.paths.commitTransaction(), (RESTRequest)new CommitTransactionRequest(tableChanges), null, Map.of(), ErrorHandlers.tableCommitHandler());
    }

    @Override
    public List<TableIdentifier> listViews(SessionCatalog.SessionContext context, Namespace namespace) {
        if (!this.endpoints.contains(Endpoint.V1_LIST_VIEWS)) {
            return ImmutableList.of();
        }
        this.checkNamespaceIsValid(namespace);
        HashMap<String, String> queryParams = Maps.newHashMap();
        ImmutableList.Builder views = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            ListTablesResponse response = this.client.withAuthSession(contextualSession).get(this.paths.views(namespace), queryParams, ListTablesResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.nextPageToken();
            views.addAll(response.identifiers());
        } while (pageToken != null);
        return views.build();
    }

    @Override
    public boolean viewExists(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        try {
            this.checkViewIdentifierIsValid(identifier);
            if (this.endpoints.contains(Endpoint.V1_VIEW_EXISTS)) {
                AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
                this.client.withAuthSession(contextualSession).head(this.paths.view(identifier), Map.of(), ErrorHandlers.viewErrorHandler());
                return true;
            }
            return super.viewExists(context, identifier);
        }
        catch (NoSuchViewException e) {
            return false;
        }
    }

    @Override
    public View loadView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_VIEW, () -> new NoSuchViewException("Unable to load view %s.%s: Server does not support endpoint %s", this.name(), identifier, Endpoint.V1_LOAD_VIEW));
        this.checkViewIdentifierIsValid(identifier);
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        LoadViewResponse response = this.client.withAuthSession(contextualSession).get(this.paths.view(identifier), LoadViewResponse.class, Map.of(), ErrorHandlers.viewErrorHandler());
        Map<String, String> tableConf = response.config();
        AuthSession tableSession = this.authManager.tableSession(identifier, tableConf, contextualSession);
        ViewMetadata metadata = response.metadata();
        RESTViewOperations ops = new RESTViewOperations(this.client.withAuthSession(tableSession), this.paths.view(identifier), Map::of, metadata, this.endpoints);
        return new BaseView(ops, ViewUtil.fullViewName(this.name(), identifier));
    }

    @Override
    public ViewBuilder buildView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        return new RESTViewBuilder(context, identifier);
    }

    @Override
    public boolean dropView(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        Endpoint.check(this.endpoints, Endpoint.V1_DELETE_VIEW);
        this.checkViewIdentifierIsValid(identifier);
        try {
            AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
            this.client.withAuthSession(contextualSession).delete(this.paths.view(identifier), null, Map.of(), ErrorHandlers.viewErrorHandler());
            return true;
        }
        catch (NoSuchViewException e) {
            return false;
        }
    }

    @Override
    public void renameView(SessionCatalog.SessionContext context, TableIdentifier from, TableIdentifier to) {
        Endpoint.check(this.endpoints, Endpoint.V1_RENAME_VIEW);
        this.checkViewIdentifierIsValid(from);
        this.checkViewIdentifierIsValid(to);
        RenameTableRequest request = RenameTableRequest.builder().withSource(from).withDestination(to).build();
        AuthSession contextualSession = this.authManager.contextualSession(context, this.catalogAuth);
        this.client.withAuthSession(contextualSession).post(this.paths.renameView(), (RESTRequest)request, null, Map.of(), ErrorHandlers.viewErrorHandler());
    }

    static enum SnapshotMode {
        ALL,
        REFS;


        Map<String, String> params() {
            return ImmutableMap.of("snapshots", this.name().toLowerCase(Locale.US));
        }
    }

    private class Builder
    implements Catalog.TableBuilder {
        private final TableIdentifier ident;
        private final Schema schema;
        private final SessionCatalog.SessionContext context;
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private PartitionSpec spec = null;
        private SortOrder writeOrder = null;
        private String location = null;

        private Builder(TableIdentifier ident, Schema schema, SessionCatalog.SessionContext context) {
            RESTSessionCatalog.this.checkIdentifierIsValid(ident);
            this.ident = ident;
            this.schema = schema;
            this.context = context;
            this.propertiesBuilder.putAll(this.tableDefaultProperties());
        }

        private Map<String, String> tableDefaultProperties() {
            Map<String, String> tableDefaultProperties = PropertyUtil.propertiesWithPrefix(RESTSessionCatalog.this.properties(), "table-default.");
            LOG.info("Table properties set at catalog level through catalog properties: {}", tableDefaultProperties);
            return tableDefaultProperties;
        }

        private Map<String, String> tableOverrideProperties() {
            Map<String, String> tableOverrideProperties = PropertyUtil.propertiesWithPrefix(RESTSessionCatalog.this.properties(), "table-override.");
            LOG.info("Table properties enforced at catalog level through catalog properties: {}", tableOverrideProperties);
            return tableOverrideProperties;
        }

        @Override
        public Builder withPartitionSpec(PartitionSpec tableSpec) {
            this.spec = tableSpec;
            return this;
        }

        @Override
        public Builder withSortOrder(SortOrder tableWriteOrder) {
            this.writeOrder = tableWriteOrder;
            return this;
        }

        @Override
        public Builder withLocation(String tableLocation) {
            this.location = tableLocation;
            return this;
        }

        @Override
        public Builder withProperties(Map<String, String> props) {
            if (props != null) {
                this.propertiesBuilder.putAll(props);
            }
            return this;
        }

        @Override
        public Builder withProperty(String key, String value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        @Override
        public Table create() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_TABLE);
            this.propertiesBuilder.putAll(this.tableOverrideProperties());
            CreateTableRequest request = CreateTableRequest.builder().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(this.propertiesBuilder.buildKeepingLast()).build();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            LoadTableResponse response = RESTSessionCatalog.this.client.withAuthSession(contextualSession).post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
            Map<String, String> tableConf = response.config();
            AuthSession tableSession = RESTSessionCatalog.this.authManager.tableSession(this.ident, tableConf, contextualSession);
            RESTClient tableClient = RESTSessionCatalog.this.client.withAuthSession(tableSession);
            RESTTableOperations ops = new RESTTableOperations(tableClient, RESTSessionCatalog.this.paths.table(this.ident), Map::of, RESTSessionCatalog.this.tableFileIO(this.context, tableConf, response.credentials()), response.tableMetadata(), RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return new BaseTable(ops, RESTSessionCatalog.this.fullTableName(this.ident), RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), tableClient));
        }

        @Override
        public Transaction createTransaction() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_TABLE);
            LoadTableResponse response = this.stageCreate();
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            Map<String, String> tableConf = response.config();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            AuthSession tableSession = RESTSessionCatalog.this.authManager.tableSession(this.ident, tableConf, contextualSession);
            TableMetadata meta = response.tableMetadata();
            RESTClient tableClient = RESTSessionCatalog.this.client.withAuthSession(tableSession);
            RESTTableOperations ops = new RESTTableOperations(tableClient, RESTSessionCatalog.this.paths.table(this.ident), Map::of, RESTSessionCatalog.this.tableFileIO(this.context, tableConf, response.credentials()), RESTTableOperations.UpdateType.CREATE, RESTSessionCatalog.createChanges(meta), meta, RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return Transactions.createTableTransaction(fullName, ops, meta, RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), tableClient));
        }

        @Override
        public Transaction replaceTransaction() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_UPDATE_TABLE);
            if (RESTSessionCatalog.this.viewExists(this.context, this.ident)) {
                throw new AlreadyExistsException("View with same name already exists: %s", this.ident);
            }
            LoadTableResponse response = RESTSessionCatalog.this.loadInternal(this.context, this.ident, RESTSessionCatalog.this.snapshotMode);
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            Map<String, String> tableConf = response.config();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            AuthSession tableSession = RESTSessionCatalog.this.authManager.tableSession(this.ident, tableConf, contextualSession);
            TableMetadata base = response.tableMetadata();
            this.propertiesBuilder.putAll(this.tableOverrideProperties());
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.buildKeepingLast();
            TableMetadata replacement = base.buildReplacement(this.schema, this.spec != null ? this.spec : PartitionSpec.unpartitioned(), this.writeOrder != null ? this.writeOrder : SortOrder.unsorted(), this.location != null ? this.location : base.location(), tableProperties);
            ImmutableList.Builder changes = ImmutableList.builder();
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetCurrentSchema.class::isInstance)) {
                changes.add(new MetadataUpdate.SetCurrentSchema(replacement.currentSchemaId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultPartitionSpec.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultPartitionSpec(replacement.defaultSpecId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultSortOrder.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultSortOrder(replacement.defaultSortOrderId()));
            }
            RESTClient tableClient = RESTSessionCatalog.this.client.withAuthSession(tableSession);
            RESTTableOperations ops = new RESTTableOperations(tableClient, RESTSessionCatalog.this.paths.table(this.ident), Map::of, RESTSessionCatalog.this.tableFileIO(this.context, tableConf, response.credentials()), RESTTableOperations.UpdateType.REPLACE, (List<MetadataUpdate>)((Object)changes.build()), base, RESTSessionCatalog.this.endpoints);
            RESTSessionCatalog.this.trackFileIO(ops);
            return Transactions.replaceTableTransaction(fullName, ops, replacement, RESTSessionCatalog.this.metricsReporter(RESTSessionCatalog.this.paths.metrics(this.ident), tableClient));
        }

        @Override
        public Transaction createOrReplaceTransaction() {
            try {
                return this.replaceTransaction();
            }
            catch (NoSuchTableException e) {
                return this.createTransaction();
            }
        }

        private LoadTableResponse stageCreate() {
            this.propertiesBuilder.putAll(this.tableOverrideProperties());
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.buildKeepingLast();
            CreateTableRequest request = CreateTableRequest.builder().stageCreate().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(tableProperties).build();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            return RESTSessionCatalog.this.client.withAuthSession(contextualSession).post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
        }
    }

    private class RESTViewBuilder
    implements ViewBuilder {
        private final SessionCatalog.SessionContext context;
        private final TableIdentifier identifier;
        private final Map<String, String> properties = Maps.newHashMap();
        private final List<ViewRepresentation> representations = Lists.newArrayList();
        private Namespace defaultNamespace = null;
        private String defaultCatalog = null;
        private Schema schema = null;
        private String location = null;

        private RESTViewBuilder(SessionCatalog.SessionContext context, TableIdentifier identifier) {
            RESTSessionCatalog.this.checkViewIdentifierIsValid(identifier);
            this.identifier = identifier;
            this.context = context;
            this.properties.putAll(this.viewDefaultProperties());
        }

        private Map<String, String> viewDefaultProperties() {
            Map<String, String> viewDefaultProperties = PropertyUtil.propertiesWithPrefix(RESTSessionCatalog.this.properties(), "view-default.");
            LOG.info("View properties set at catalog level through catalog properties: {}", viewDefaultProperties);
            return viewDefaultProperties;
        }

        private Map<String, String> viewOverrideProperties() {
            Map<String, String> viewOverrideProperties = PropertyUtil.propertiesWithPrefix(RESTSessionCatalog.this.properties(), "view-override.");
            LOG.info("View properties enforced at catalog level through catalog properties: {}", viewOverrideProperties);
            return viewOverrideProperties;
        }

        @Override
        public ViewBuilder withSchema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        @Override
        public ViewBuilder withQuery(String dialect, String sql) {
            this.representations.add(ImmutableSQLViewRepresentation.builder().dialect(dialect).sql(sql).build());
            return this;
        }

        @Override
        public ViewBuilder withDefaultCatalog(String catalog) {
            this.defaultCatalog = catalog;
            return this;
        }

        @Override
        public ViewBuilder withDefaultNamespace(Namespace namespace) {
            this.defaultNamespace = namespace;
            return this;
        }

        @Override
        public ViewBuilder withProperties(Map<String, String> newProperties) {
            this.properties.putAll(newProperties);
            return this;
        }

        @Override
        public ViewBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        @Override
        public ViewBuilder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        @Override
        public View create() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_CREATE_VIEW);
            Preconditions.checkState(!this.representations.isEmpty(), "Cannot create view without specifying a query");
            Preconditions.checkState(null != this.schema, "Cannot create view without specifying schema");
            Preconditions.checkState(null != this.defaultNamespace, "Cannot create view without specifying a default namespace");
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            this.properties.putAll(this.viewOverrideProperties());
            ImmutableCreateViewRequest request = ImmutableCreateViewRequest.builder().name(this.identifier.name()).location(this.location).schema(this.schema).viewVersion(viewVersion).properties(this.properties).build();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            LoadViewResponse response = RESTSessionCatalog.this.client.withAuthSession(contextualSession).post(RESTSessionCatalog.this.paths.views(this.identifier.namespace()), (RESTRequest)request, LoadViewResponse.class, Map.of(), ErrorHandlers.viewErrorHandler());
            Map<String, String> tableConf = response.config();
            AuthSession tableSession = RESTSessionCatalog.this.authManager.tableSession(this.identifier, tableConf, contextualSession);
            RESTViewOperations ops = new RESTViewOperations(RESTSessionCatalog.this.client.withAuthSession(tableSession), RESTSessionCatalog.this.paths.view(this.identifier), Map::of, response.metadata(), RESTSessionCatalog.this.endpoints);
            return new BaseView(ops, ViewUtil.fullViewName(RESTSessionCatalog.this.name(), this.identifier));
        }

        @Override
        public View createOrReplace() {
            try {
                return this.replace(this.loadView());
            }
            catch (NoSuchViewException e) {
                return this.create();
            }
        }

        @Override
        public View replace() {
            if (RESTSessionCatalog.this.tableExists(this.context, this.identifier)) {
                throw new AlreadyExistsException("Table with same name already exists: %s", this.identifier);
            }
            return this.replace(this.loadView());
        }

        private LoadViewResponse loadView() {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_LOAD_VIEW, () -> new NoSuchViewException("Unable to load view %s.%s: Server does not support endpoint %s", RESTSessionCatalog.this.name(), this.identifier, Endpoint.V1_LOAD_VIEW));
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            return RESTSessionCatalog.this.client.withAuthSession(contextualSession).get(RESTSessionCatalog.this.paths.view(this.identifier), LoadViewResponse.class, Map.of(), ErrorHandlers.viewErrorHandler());
        }

        private View replace(LoadViewResponse response) {
            Endpoint.check(RESTSessionCatalog.this.endpoints, Endpoint.V1_UPDATE_VIEW);
            Preconditions.checkState(!this.representations.isEmpty(), "Cannot replace view without specifying a query");
            Preconditions.checkState(null != this.schema, "Cannot replace view without specifying schema");
            Preconditions.checkState(null != this.defaultNamespace, "Cannot replace view without specifying a default namespace");
            ViewMetadata metadata = response.metadata();
            int maxVersionId = metadata.versions().stream().map(ViewVersion::versionId).max(Integer::compareTo).orElseGet(metadata::currentVersionId);
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(maxVersionId + 1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            this.properties.putAll(this.viewOverrideProperties());
            ViewMetadata.Builder builder = ViewMetadata.buildFrom(metadata).setProperties(this.properties).setCurrentVersion(viewVersion, this.schema);
            if (null != this.location) {
                builder.setLocation(this.location);
            }
            ViewMetadata replacement = builder.build();
            Map<String, String> tableConf = response.config();
            AuthSession contextualSession = RESTSessionCatalog.this.authManager.contextualSession(this.context, RESTSessionCatalog.this.catalogAuth);
            AuthSession tableSession = RESTSessionCatalog.this.authManager.tableSession(this.identifier, tableConf, contextualSession);
            RESTViewOperations ops = new RESTViewOperations(RESTSessionCatalog.this.client.withAuthSession(tableSession), RESTSessionCatalog.this.paths.view(this.identifier), Map::of, metadata, RESTSessionCatalog.this.endpoints);
            ops.commit(metadata, replacement);
            return new BaseView(ops, ViewUtil.fullViewName(RESTSessionCatalog.this.name(), this.identifier));
        }
    }
}

