/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundPartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import java.util.Map;
import java.util.Objects;

public class CreateTableRequest
implements RESTRequest {
    private String name;
    private String location;
    private Schema schema;
    private UnboundPartitionSpec partitionSpec;
    private UnboundSortOrder writeOrder;
    private Map<String, String> properties;
    private Boolean stageCreate = false;

    public CreateTableRequest() {
    }

    private CreateTableRequest(String name, String location, Schema schema, PartitionSpec partitionSpec, SortOrder writeOrder, Map<String, String> properties, boolean stageCreate) {
        this.name = name;
        this.location = location;
        this.schema = schema;
        this.partitionSpec = partitionSpec != null ? partitionSpec.toUnbound() : null;
        this.writeOrder = writeOrder != null ? writeOrder.toUnbound() : null;
        this.properties = properties;
        this.stageCreate = stageCreate;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.name != null, "Invalid table name: null");
        Preconditions.checkArgument(this.schema != null, "Invalid schema: null");
        Preconditions.checkArgument(this.stageCreate != null, "Invalid stageCreate flag: null");
    }

    public String name() {
        return this.name;
    }

    public String location() {
        return this.location;
    }

    public Schema schema() {
        return this.schema;
    }

    public PartitionSpec spec() {
        return this.partitionSpec != null ? this.partitionSpec.bind(this.schema) : null;
    }

    public SortOrder writeOrder() {
        return this.writeOrder != null ? this.writeOrder.bind(this.schema) : null;
    }

    public Map<String, String> properties() {
        return this.properties != null ? this.properties : ImmutableMap.of();
    }

    public boolean stageCreate() {
        return this.stageCreate;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("location", this.location).add("properties", this.properties).add("schema", this.schema).add("partitionSpec", this.partitionSpec).add("writeOrder", this.writeOrder).add("stageCreate", this.stageCreate).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String location;
        private Schema schema;
        private PartitionSpec partitionSpec;
        private SortOrder writeOrder;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        private boolean stageCreate = false;

        private Builder() {
        }

        public Builder withName(String tableName) {
            Preconditions.checkNotNull(tableName, "Invalid name: null");
            this.name = tableName;
            return this;
        }

        public Builder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        public Builder setProperty(String property, String value) {
            Preconditions.checkArgument(property != null, "Invalid property: null");
            Preconditions.checkArgument(value != null, "Invalid value for property %s: null", (Object)property);
            this.properties.put(property, value);
            return this;
        }

        public Builder setProperties(Map<String, String> props) {
            Preconditions.checkNotNull(props, "Invalid collection of properties: null");
            Preconditions.checkArgument(!props.containsKey(null), "Invalid property: null");
            Preconditions.checkArgument(!props.containsValue(null), "Invalid value for properties %s: null", Maps.filterValues(props, Objects::isNull).keySet());
            this.properties.putAll(props);
            return this;
        }

        public Builder withSchema(Schema tableSchema) {
            Preconditions.checkNotNull(tableSchema, "Invalid schema: null");
            this.schema = tableSchema;
            return this;
        }

        public Builder withPartitionSpec(PartitionSpec tableSpec) {
            this.partitionSpec = tableSpec;
            return this;
        }

        public Builder withWriteOrder(SortOrder order) {
            this.writeOrder = order;
            return this;
        }

        public Builder stageCreate() {
            this.stageCreate = true;
            return this;
        }

        public CreateTableRequest build() {
            return new CreateTableRequest(this.name, this.location, this.schema, this.partitionSpec, this.writeOrder, this.properties.build(), this.stageCreate);
        }
    }
}

