/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Dates;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.SerializationProxies;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TimeTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Timestamps;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TransformUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.io.ObjectStreamException;
import java.time.temporal.ChronoUnit;

class Years<T>
extends TimeTransform<T> {
    private static final Years<?> INSTANCE = new Years();

    Years() {
    }

    static <T> Years<T> get() {
        return INSTANCE;
    }

    @Override
    protected ChronoUnit granularity() {
        return ChronoUnit.YEARS;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        return Years.fromSourceType(type, Dates.YEAR, Timestamps.MICROS_TO_YEAR, Timestamps.NANOS_TO_YEAR);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public String toHumanString(Type alwaysInt, Integer value) {
        return value != null ? TransformUtil.humanYear(value) : "null";
    }

    public String toString() {
        return "year";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.YearsTransformProxy.get();
    }
}

