/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.types;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.UUIDUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public class Conversions {
    private static final String HIVE_NULL = "__HIVE_DEFAULT_PARTITION__";
    private static final ThreadLocal<CharsetEncoder> ENCODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final ThreadLocal<CharsetDecoder> DECODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);

    private Conversions() {
    }

    public static Object fromPartitionString(Type type, String asString2) {
        if (asString2 == null || HIVE_NULL.equals(asString2)) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return Boolean.valueOf(asString2);
            }
            case INTEGER: {
                return Integer.valueOf(asString2);
            }
            case LONG: {
                return Long.valueOf(asString2);
            }
            case FLOAT: {
                return Float.valueOf(asString2);
            }
            case DOUBLE: {
                return Double.valueOf(asString2);
            }
            case STRING: {
                return asString2;
            }
            case UUID: {
                return UUID.fromString(asString2);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)type;
                return Arrays.copyOf(asString2.getBytes(StandardCharsets.UTF_8), fixed.length());
            }
            case BINARY: {
                return asString2.getBytes(StandardCharsets.UTF_8);
            }
            case DECIMAL: {
                return new BigDecimal(asString2);
            }
            case DATE: {
                return Literal.of(asString2).to(Types.DateType.get()).value();
            }
        }
        throw new UnsupportedOperationException("Unsupported type for fromPartitionString: " + String.valueOf(type));
    }

    public static ByteBuffer toByteBuffer(Type type, Object value) {
        return Conversions.toByteBuffer(type.typeId(), value);
    }

    public static ByteBuffer toByteBuffer(Type.TypeID typeId, Object value) {
        if (value == null) {
            return null;
        }
        switch (typeId) {
            case BOOLEAN: {
                return ByteBuffer.allocate(1).put(0, (Boolean)value != false ? (byte)1 : 0);
            }
            case INTEGER: 
            case DATE: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(0, (Integer)value);
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_NANO: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, (Long)value);
            }
            case FLOAT: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(0, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, (Double)value);
            }
            case STRING: {
                CharBuffer buffer = CharBuffer.wrap((CharSequence)value);
                try {
                    return ENCODER.get().encode(buffer);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeIOException(e, "Failed to encode value as UTF-8: %s", value);
                }
            }
            case UUID: {
                return UUIDUtil.convertToByteBuffer((UUID)value);
            }
            case FIXED: 
            case BINARY: {
                return (ByteBuffer)value;
            }
            case DECIMAL: {
                return ByteBuffer.wrap(((BigDecimal)value).unscaledValue().toByteArray());
            }
        }
        throw new UnsupportedOperationException("Cannot serialize type: " + String.valueOf((Object)typeId));
    }

    public static <T> T fromByteBuffer(Type type, ByteBuffer buffer) {
        return (T)Conversions.internalFromByteBuffer(type, buffer);
    }

    private static Object internalFromByteBuffer(Type type, ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer tmp = buffer.duplicate();
        if (type == Types.UUIDType.get() || type instanceof Types.DecimalType) {
            tmp.order(ByteOrder.BIG_ENDIAN);
        } else {
            tmp.order(ByteOrder.LITTLE_ENDIAN);
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return tmp.get() != 0;
            }
            case INTEGER: 
            case DATE: {
                return tmp.getInt();
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_NANO: {
                if (tmp.remaining() < 8) {
                    return (long)tmp.getInt();
                }
                return tmp.getLong();
            }
            case FLOAT: {
                return Float.valueOf(tmp.getFloat());
            }
            case DOUBLE: {
                if (tmp.remaining() < 8) {
                    return (double)tmp.getFloat();
                }
                return tmp.getDouble();
            }
            case STRING: {
                try {
                    return DECODER.get().decode(tmp);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeIOException(e, "Failed to decode value as UTF-8: %s", buffer);
                }
            }
            case UUID: {
                return UUIDUtil.convert(tmp);
            }
            case FIXED: 
            case BINARY: {
                return tmp;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)type;
                byte[] unscaledBytes = new byte[buffer.remaining()];
                tmp.get(unscaledBytes);
                return new BigDecimal(new BigInteger(unscaledBytes), decimal.scale());
            }
        }
        throw new UnsupportedOperationException("Cannot deserialize type: " + String.valueOf(type));
    }
}

