/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.types;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.List;
import java.util.Set;

class GetProjectedIds
extends TypeUtil.SchemaVisitor<Set<Integer>> {
    private final boolean includeStructIds;
    private final Set<Integer> fieldIds = Sets.newHashSet();

    GetProjectedIds() {
        this(false);
    }

    GetProjectedIds(boolean includeStructIds) {
        this.includeStructIds = includeStructIds;
    }

    @Override
    public Set<Integer> schema(Schema schema, Set<Integer> structResult) {
        return this.fieldIds;
    }

    @Override
    public Set<Integer> struct(Types.StructType struct, List<Set<Integer>> fieldResults) {
        return this.fieldIds;
    }

    @Override
    public Set<Integer> field(Types.NestedField field, Set<Integer> fieldResult) {
        if (this.includeStructIds && field.type().isStructType() || field.type().isPrimitiveType() || field.type().isVariantType()) {
            this.fieldIds.add(field.fieldId());
        }
        return this.fieldIds;
    }

    @Override
    public Set<Integer> list(Types.ListType list, Set<Integer> elementResult) {
        if (elementResult == null) {
            for (Types.NestedField field : list.fields()) {
                this.fieldIds.add(field.fieldId());
            }
        }
        return this.fieldIds;
    }

    @Override
    public Set<Integer> map(Types.MapType map, Set<Integer> keyResult, Set<Integer> valueResult) {
        if (valueResult == null) {
            for (Types.NestedField field : map.fields()) {
                this.fieldIds.add(field.fieldId());
            }
        }
        return this.fieldIds;
    }

    @Override
    public Set<Integer> variant(Types.VariantType variant) {
        return null;
    }
}

