/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.WrapperSet;
import java.util.Objects;

public class DataFileSet
extends WrapperSet<DataFile> {
    private static final ThreadLocal<DataFileWrapper> WRAPPERS = ThreadLocal.withInitial(() -> DataFileWrapper.wrap(null));

    private DataFileSet() {
    }

    private DataFileSet(Iterable<WrapperSet.Wrapper<DataFile>> wrappers) {
        super(wrappers);
    }

    public static DataFileSet create() {
        return new DataFileSet();
    }

    public static DataFileSet of(Iterable<? extends DataFile> iterable) {
        return new DataFileSet(Iterables.transform(iterable, obj -> {
            Preconditions.checkNotNull(obj, "Invalid object: null");
            return DataFileWrapper.wrap(obj);
        }));
    }

    @Override
    protected WrapperSet.Wrapper<DataFile> wrapper() {
        return WRAPPERS.get();
    }

    @Override
    protected WrapperSet.Wrapper<DataFile> wrap(DataFile dataFile) {
        return DataFileWrapper.wrap(dataFile);
    }

    @Override
    protected Class<DataFile> elementClass() {
        return DataFile.class;
    }

    private static class DataFileWrapper
    implements WrapperSet.Wrapper<DataFile> {
        private DataFile file;

        private DataFileWrapper(DataFile file) {
            this.file = file;
        }

        private static DataFileWrapper wrap(DataFile dataFile) {
            return new DataFileWrapper(dataFile);
        }

        @Override
        public DataFile get() {
            return this.file;
        }

        @Override
        public WrapperSet.Wrapper<DataFile> set(DataFile dataFile) {
            this.file = dataFile;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataFileWrapper)) {
                return false;
            }
            DataFileWrapper that = (DataFileWrapper)o;
            return Objects.equals(this.file.location(), that.file.location());
        }

        public int hashCode() {
            return Objects.hashCode(this.file.location());
        }

        public String toString() {
            return this.file.location();
        }
    }
}

