/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.view;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.PropertiesUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ReplaceViewVersion;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.SQLViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.SetViewLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.UpdateViewProperties;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.View;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewHistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersionReplace;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BaseView
implements View,
Serializable {
    private final ViewOperations ops;
    private final String name;

    public BaseView(ViewOperations ops, String name) {
        this.ops = ops;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public ViewOperations operations() {
        return this.ops;
    }

    @Override
    public Schema schema() {
        return this.operations().current().schema();
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return this.operations().current().schemasById();
    }

    @Override
    public ViewVersion currentVersion() {
        return this.operations().current().currentVersion();
    }

    @Override
    public Iterable<ViewVersion> versions() {
        return this.operations().current().versions();
    }

    @Override
    public ViewVersion version(int versionId) {
        return this.operations().current().version(versionId);
    }

    @Override
    public List<ViewHistoryEntry> history() {
        return this.operations().current().history();
    }

    @Override
    public Map<String, String> properties() {
        return this.operations().current().properties();
    }

    @Override
    public String location() {
        return this.operations().current().location();
    }

    @Override
    public UpdateViewProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    @Override
    public ReplaceViewVersion replaceVersion() {
        return new ViewVersionReplace(this.ops);
    }

    @Override
    public UpdateLocation updateLocation() {
        return new SetViewLocation(this.ops);
    }

    @Override
    public UUID uuid() {
        return UUID.fromString(this.ops.current().uuid());
    }

    @Override
    public SQLViewRepresentation sqlFor(String dialect) {
        Preconditions.checkArgument(dialect != null, "Invalid dialect: null");
        Preconditions.checkArgument(!dialect.isEmpty(), "Invalid dialect: (empty string)");
        SQLViewRepresentation closest = null;
        for (ViewRepresentation representation : this.currentVersion().representations()) {
            if (!(representation instanceof SQLViewRepresentation)) continue;
            SQLViewRepresentation sqlViewRepresentation = (SQLViewRepresentation)representation;
            if (sqlViewRepresentation.dialect().equalsIgnoreCase(dialect)) {
                return sqlViewRepresentation;
            }
            if (closest != null) continue;
            closest = sqlViewRepresentation;
        }
        return closest;
    }
}

