/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball.SnowballFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import com.dataiku.dss.shadelib.org.tartarus.snowball.SnowballStemmer;
import java.io.IOException;
import java.util.Map;

public class SnowballPorterFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "snowballPorter";
    public static final String PROTECTED_TOKENS = "protected";
    private final String language;
    private final String wordFiles;
    private Class<? extends SnowballStemmer> stemClass;
    private CharArraySet protectedWords = null;

    public SnowballPorterFilterFactory(Map<String, String> args2) {
        super(args2);
        this.language = this.get(args2, "language", "English");
        this.wordFiles = this.get(args2, PROTECTED_TOKENS);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public SnowballPorterFilterFactory() {
        throw SnowballPorterFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String className = "com.dataiku.dss.shadelib.org.tartarus.snowball.ext." + this.language + "Stemmer";
        this.stemClass = loader.newInstance(className, SnowballStemmer.class).getClass();
        if (this.wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, this.wordFiles, false);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        SnowballStemmer program;
        try {
            program = this.stemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e);
        }
        if (this.protectedWords != null) {
            input = new SetKeywordMarkerFilter(input, this.protectedWords);
        }
        return new SnowballFilter(input, program);
    }
}

