/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.Field;
import com.dataiku.dss.shadelib.org.apache.lucene.document.FieldType;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PointInSetQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PointRangeQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.NumericUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class InetAddressPoint
extends Field {
    public static final int BYTES = 16;
    static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static final FieldType TYPE = new FieldType();
    public static final InetAddress MIN_VALUE;
    public static final InetAddress MAX_VALUE;

    public static InetAddress nextUp(InetAddress address) {
        if (address.equals(MAX_VALUE)) {
            throw new ArithmeticException("Overflow: there is no greater InetAddress than " + address.getHostAddress());
        }
        byte[] delta = new byte[16];
        delta[15] = 1;
        byte[] nextUpBytes = new byte[16];
        NumericUtils.add(16, 0, InetAddressPoint.encode(address), delta, nextUpBytes);
        return InetAddressPoint.decode(nextUpBytes);
    }

    public static InetAddress nextDown(InetAddress address) {
        if (address.equals(MIN_VALUE)) {
            throw new ArithmeticException("Underflow: there is no smaller InetAddress than " + address.getHostAddress());
        }
        byte[] delta = new byte[16];
        delta[15] = 1;
        byte[] nextDownBytes = new byte[16];
        NumericUtils.subtract(16, 0, InetAddressPoint.encode(address), delta, nextDownBytes);
        return InetAddressPoint.decode(nextDownBytes);
    }

    public void setInetAddressValue(InetAddress value) {
        if (value == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        this.fieldsData = new BytesRef(InetAddressPoint.encode(value));
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from InetAddress to BytesRef");
    }

    public InetAddressPoint(String name, InetAddress point) {
        super(name, TYPE);
        this.setInetAddressValue(point);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        InetAddress address = InetAddressPoint.decode(BytesRef.deepCopyOf((BytesRef)bytes).bytes);
        if (address.getAddress().length == 16) {
            result.append('[');
            result.append(address.getHostAddress());
            result.append(']');
        } else {
            result.append(address.getHostAddress());
        }
        result.append('>');
        return result.toString();
    }

    public static byte[] encode(InetAddress value) {
        byte[] address = value.getAddress();
        if (address.length == 4) {
            byte[] mapped = new byte[16];
            System.arraycopy(IPV4_PREFIX, 0, mapped, 0, IPV4_PREFIX.length);
            System.arraycopy(address, 0, mapped, IPV4_PREFIX.length, address.length);
            address = mapped;
        } else if (address.length != 16) {
            throw new UnsupportedOperationException("Only IPv4 and IPv6 addresses are supported");
        }
        return address;
    }

    public static InetAddress decode(byte[] value) {
        try {
            return InetAddress.getByAddress(value);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("encoded bytes are of incorrect length", e);
        }
    }

    public static Query newExactQuery(String field, InetAddress value) {
        return InetAddressPoint.newRangeQuery(field, value, value);
    }

    public static Query newPrefixQuery(String field, InetAddress value, int prefixLength) {
        if (value == null) {
            throw new IllegalArgumentException("InetAddress must not be null");
        }
        if (prefixLength < 0 || prefixLength > 8 * value.getAddress().length) {
            throw new IllegalArgumentException("illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
        }
        byte[] lower = value.getAddress();
        byte[] upper = value.getAddress();
        for (int i = prefixLength; i < 8 * lower.length; ++i) {
            int m4 = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m4);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m4);
        }
        try {
            return InetAddressPoint.newRangeQuery(field, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Query newRangeQuery(String field, InetAddress lowerValue, InetAddress upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return new PointRangeQuery(field, InetAddressPoint.encode(lowerValue), InetAddressPoint.encode(upperValue), 1){

            @Override
            protected String toString(int dimension, byte[] value) {
                return InetAddressPoint.decode(value).getHostAddress();
            }
        };
    }

    public static Query newSetQuery(String field, InetAddress ... values2) {
        final byte[][] sortedValues = new byte[values2.length][];
        for (int i = 0; i < values2.length; ++i) {
            sortedValues[i] = InetAddressPoint.encode(values2[i]);
        }
        Arrays.sort(sortedValues, (a, b) -> Arrays.compareUnsigned(a, 0, 16, b, 0, 16));
        final BytesRef encoded = new BytesRef(new byte[16]);
        return new PointInSetQuery(field, 1, 16, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                encoded.bytes = sortedValues[this.upto];
                assert (encoded.bytes.length == encoded.length);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 16);
                return InetAddressPoint.decode(value).getHostAddress();
            }
        };
    }

    static {
        TYPE.setDimensions(1, 16);
        TYPE.freeze();
        MIN_VALUE = InetAddressPoint.decode(new byte[16]);
        byte[] maxValueBytes = new byte[16];
        Arrays.fill(maxValueBytes, (byte)-1);
        MAX_VALUE = InetAddressPoint.decode(maxValueBytes);
    }
}

