/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.BinaryRangeFieldRangeQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.document.IntRange;
import com.dataiku.dss.shadelib.org.apache.lucene.document.RangeFieldQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

class IntRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final int[] min;
    private final int[] max;

    IntRangeSlowRangeQuery(String field, int[] min2, int[] max, RangeFieldQuery.QueryType queryType) {
        super(field, IntRangeSlowRangeQuery.encodeRanges(min2, max), 4, min2.length, queryType);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        IntRangeSlowRangeQuery that = (IntRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Arrays.hashCode(this.min);
        h2 = 31 * h2 + Arrays.hashCode(this.max);
        return h2;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private static byte[] encodeRanges(int[] min2, int[] max) {
        byte[] result = new byte[8 * min2.length];
        IntRange.verifyAndEncode(min2, max, result);
        return result;
    }
}

